/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.unwrap;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;

public class JEIDynamicDisplayGenerator
implements DynamicDisplayGenerator<Display> {
    private final IRecipeManagerPlugin plugin;

    public JEIDynamicDisplayGenerator(IRecipeManagerPlugin plugin) {
        this.plugin = plugin;
    }

    private Optional<List<Display>> getDisplays(EntryStack<?> entry, RecipeIngredientRole role) {
        JEIFocus focus = new JEIFocus(role, JEIPluginDetector.typedJeiValue(entry));
        List<RecipeType<?>> categoryIds = this.plugin.getRecipeTypes(focus);
        if (categoryIds.isEmpty()) {
            return Optional.empty();
        }
        List displays = null;
        for (RecipeType<?> categoryId : categoryIds) {
            IRecipeCategory<?> category = JEIPluginDetector.wrapCategory(CategoryRegistry.getInstance().get(JEIPluginDetector.categoryId(categoryId)).getCategory());
            List<?> recipes = this.plugin.getRecipes(category, focus);
            if (recipes == null || recipes.isEmpty()) continue;
            if (displays == null) {
                displays = CollectionUtils.flatMap(recipes, JEIPluginDetector::createDisplayFrom);
                continue;
            }
            displays.addAll(CollectionUtils.flatMap(recipes, JEIPluginDetector::createDisplayFrom));
        }
        if (displays == null) {
            return Optional.empty();
        }
        return Optional.of(CollectionUtils.filterToList(displays, Objects::nonNull));
    }

    @Override
    public Optional<List<Display>> getRecipeFor(EntryStack<?> entry) {
        return this.getDisplays(entry, RecipeIngredientRole.OUTPUT);
    }

    @Override
    public Optional<List<Display>> getUsageFor(EntryStack<?> entry) {
        return this.getDisplays(entry, RecipeIngredientRole.INPUT);
    }

    @Override
    public Optional<List<Display>> generate(ViewSearchBuilder builder) {
        ArrayList displays = null;
        for (CategoryIdentifier<?> category : builder.getCategories()) {
            IRecipeCategory<?> jeiCategory = JEIPluginDetector.wrapCategory(CategoryRegistry.getInstance().get(category).getCategory());
            List<?> recipes = this.plugin.getRecipes(jeiCategory);
            if (recipes == null || recipes.isEmpty()) continue;
            if (displays == null) {
                displays = new ArrayList(CollectionUtils.flatMap(recipes, JEIPluginDetector::createDisplayFrom));
                continue;
            }
            displays.addAll(CollectionUtils.flatMap(recipes, JEIPluginDetector::createDisplayFrom));
        }
        if (displays == null) {
            return Optional.empty();
        }
        return Optional.of(CollectionUtils.filterToList(displays, Objects::nonNull));
    }
}

