/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.ingredient;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeLayoutBuilder;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeSlot;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JEIGuiIngredientGroup<T>
implements IGuiIngredientGroup<T> {
    private final IIngredientType<T> type;
    private final JEIRecipeLayoutBuilder builder;
    private final Int2ObjectMap<SlotWrapper> slots = new Int2ObjectOpenHashMap();
    public final List<ITooltipCallback<T>> tooltipCallbacks = new ArrayList<ITooltipCallback<T>>();

    public JEIGuiIngredientGroup(IIngredientType<T> type, JEIRecipeLayoutBuilder builder) {
        this.type = type;
        this.builder = builder;
    }

    public IIngredientType<T> getType() {
        return this.type;
    }

    protected SlotWrapper getSlot(int slotIndex) {
        return (SlotWrapper)this.slots.computeIfAbsent(slotIndex, i -> new SlotWrapper(i, (JEIRecipeSlot)this.builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 0, i)));
    }

    public Int2ObjectMap<SlotWrapper> getSlots() {
        return this.slots;
    }

    @Override
    public void set(@NotNull IIngredients ingredients) {
        List<List<T>> inputs = ingredients.getInputs(this.type);
        List<List<T>> outputs = ingredients.getOutputs(this.type);
        int inputIndex = 0;
        int outputIndex = 0;
        int[] array = this.slots.keySet().toArray(new int[0]);
        Arrays.parallelSort(array);
        for (int slot : array) {
            SlotWrapper slotWrapper = (SlotWrapper)this.slots.get(slot);
            if (slotWrapper.slot.role == RecipeIngredientRole.INPUT) {
                if (inputIndex >= inputs.size()) continue;
                slotWrapper.slot.slot.clearEntries();
                slotWrapper.slot.slot.entries(JEIPluginDetector.unwrapList(this.type, inputs.get(inputIndex++)));
                continue;
            }
            if (slotWrapper.slot.role != RecipeIngredientRole.OUTPUT || outputIndex >= outputs.size()) continue;
            slotWrapper.slot.slot.clearEntries();
            slotWrapper.slot.slot.entries(JEIPluginDetector.unwrapList(this.type, outputs.get(outputIndex++)));
        }
    }

    @Override
    public void set(int slotIndex, @Nullable List<T> ingredients) {
        Slot slot = this.getSlot((int)slotIndex).slot.slot;
        slot.clearEntries();
        slot.entries(JEIPluginDetector.unwrapList(this.type, ingredients));
    }

    @Override
    public void set(int slotIndex, @Nullable T ingredient) {
        Slot slot = this.getSlot((int)slotIndex).slot.slot;
        slot.clearEntries();
        slot.entry(JEIPluginDetector.unwrapStack(ingredient, this.type));
    }

    @Override
    public void setBackground(int slotIndex, @NotNull IDrawable background) {
        SlotWrapper slot = this.getSlot(slotIndex);
        slot.slot.setBackground(background, 0, 0);
    }

    @Override
    public void addTooltipCallback(@NotNull ITooltipCallback<T> tooltipCallback) {
        this.tooltipCallbacks.add(Objects.requireNonNull(tooltipCallback, "tooltipCallback"));
    }

    @NotNull
    public Int2ObjectMap<SlotWrapper> getGuiIngredients() {
        return this.slots;
    }

    @Override
    public void init(int slotIndex, boolean input, int xPosition, int yPosition) {
        SlotWrapper slot = this.getSlot(slotIndex);
        slot.slot.role = input ? RecipeIngredientRole.INPUT : RecipeIngredientRole.OUTPUT;
        slot.slot.slot.getBounds().setLocation(xPosition - 1, yPosition - 1);
    }

    @Override
    public void init(int slotIndex, boolean input, @NotNull IIngredientRenderer<T> ingredientRenderer, int xPosition, int yPosition, int width, int height, int xPadding, int yPadding) {
        SlotWrapper slot = this.getSlot(slotIndex);
        slot.slot.role = input ? RecipeIngredientRole.INPUT : RecipeIngredientRole.OUTPUT;
        slot.slot.slot.getBounds().setLocation(xPosition - 1, yPosition - 1);
        slot.slot.slot.getBounds().setSize(width + 2, height + 2);
        slot.slot.setCustomRenderer(this.type, ingredientRenderer);
    }

    @Override
    public void setOverrideDisplayFocus(@Nullable IFocus<T> focus) {
        InternalLogger.getInstance().error("setOverrideDisplayFocus is not supported in REI yet!");
    }

    public class SlotWrapper
    extends AbstractList<T>
    implements IGuiIngredient<T> {
        public JEIRecipeSlot slot;
        public final int index;

        public SlotWrapper(int index, JEIRecipeSlot slot) {
            this.index = index;
            this.slot = slot;
        }

        @Override
        @NotNull
        public IIngredientType<T> getIngredientType() {
            return JEIGuiIngredientGroup.this.type;
        }

        @Override
        @Nullable
        public T getDisplayedIngredient() {
            return this.slot.getDisplayedIngredient(JEIGuiIngredientGroup.this.type).orElse(null);
        }

        @Override
        @NotNull
        public List<T> getAllIngredients() {
            return this;
        }

        @Override
        public boolean isInput() {
            return this.slot.getRole() == RecipeIngredientRole.INPUT || this.slot.getRole() == RecipeIngredientRole.CATALYST;
        }

        @Override
        public void drawHighlight(@NotNull PoseStack matrixStack, int color, int xOffset, int yOffset) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)xOffset, (double)yOffset, 0.0);
            this.slot.drawHighlight(matrixStack, color);
            matrixStack.m_85849_();
        }

        @Override
        public T get(int index) {
            return JEIPluginDetector.jeiValueOrNull(this.slot.slot.getEntries().get(index).cast());
        }

        @Override
        public int size() {
            return this.slot.slot.getEntries().size();
        }

        @Override
        public void clear() {
            this.slot.slot.clearEntries();
        }

        @Override
        public void add(int index, T element) {
            this.slot.slot.entry(JEIPluginDetector.unwrapStack(element, JEIGuiIngredientGroup.this.type));
        }
    }
}

