/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.plugins;

import com.google.common.base.Stopwatch;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.mojang.datafixers.util.Pair;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.GameInstance;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.PluginView;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.plugins.REIPluginProvider;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.registry.Reloadable;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.logging.performance.PerformanceLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PluginManagerImpl<P extends REIPlugin<?>>
implements PluginManager<P>,
PluginView<P> {
    private final List<Reloadable<P>> reloadables = new ArrayList<Reloadable<P>>();
    private final Map<Class<? extends Reloadable<P>>, Reloadable<? super P>> cache = new ConcurrentHashMap<Class<? extends Reloadable<P>>, Reloadable<? super P>>();
    private final Class<P> pluginClass;
    private final UnaryOperator<PluginView<P>> view;
    @Nullable
    private ReloadStage reloading = null;
    private List<ReloadStage> observedStages = new ArrayList<ReloadStage>();
    private final List<REIPluginProvider<P>> plugins = new ArrayList<REIPluginProvider<P>>();
    private final Stopwatch reloadStopwatch = Stopwatch.createUnstarted();
    private boolean forcedMainThread;
    private final Stopwatch forceMainThreadStopwatch = Stopwatch.createUnstarted();

    @SafeVarargs
    public PluginManagerImpl(Class<P> pluginClass, UnaryOperator<PluginView<P>> view, Reloadable<? extends P> ... reloadables) {
        this.pluginClass = pluginClass;
        this.view = view;
        for (Reloadable<? extends P> reloadable : reloadables) {
            this.registerReloadable(reloadable);
        }
    }

    @Override
    public void registerReloadable(Reloadable<? extends P> reloadable) {
        this.reloadables.add(reloadable);
    }

    @Override
    public boolean isReloading() {
        return this.reloading != null;
    }

    @Override
    public <T extends Reloadable<? super P>> T get(Class<T> reloadableClass) {
        Reloadable<? super P> reloadable = this.cache.get(reloadableClass);
        if (reloadable != null) {
            return (T)reloadable;
        }
        for (Reloadable<P> r : this.reloadables) {
            if (!reloadableClass.isInstance(r)) continue;
            this.cache.put(reloadableClass, r);
            return (T)r;
        }
        throw new IllegalArgumentException("Unknown reloadable type! " + reloadableClass.getName());
    }

    @Override
    public List<Reloadable<P>> getReloadables() {
        return Collections.unmodifiableList(this.reloadables);
    }

    @Override
    public PluginView<P> view() {
        return (PluginView)this.view.apply(this);
    }

    @Override
    public void registerPlugin(REIPluginProvider<? extends P> plugin) {
        this.plugins.add(plugin);
        InternalLogger.getInstance().info("Registered plugin provider %s for %s", plugin.getPluginProviderName(), PluginManagerImpl.name(this.pluginClass));
    }

    @Override
    public List<REIPluginProvider<P>> getPluginProviders() {
        return Collections.unmodifiableList(this.plugins);
    }

    @Override
    public FluentIterable<P> getPlugins() {
        return FluentIterable.concat((Iterable)Iterables.transform(this.plugins, REIPluginProvider::provide));
    }

    public FluentIterable<PluginWrapper<P>> getPluginWrapped() {
        return FluentIterable.concat((Iterable)Iterables.transform(this.plugins, input -> Iterables.transform(input.provide(), plugin -> new PluginWrapper<REIPlugin>((REIPlugin)plugin, (REIPluginProvider<REIPlugin>)input))));
    }

    private SectionClosable section(ReloadStage stage, String section) {
        return new SectionClosable(stage, section);
    }

    private void pluginSection(ReloadStage stage, String sectionName, List<PluginWrapper<P>> list, @Nullable Reloadable<?> reloadable, BiConsumer<PluginWrapper<P>, SectionPluginSink> consumer) {
        for (PluginWrapper<P> wrapper : list) {
            try {
                SectionClosable section = this.section(stage, sectionName + wrapper.getPluginProviderName() + "/");
                try {
                    consumer.accept(wrapper, (respectMainThread, runnable) -> {
                        if (!respectMainThread || reloadable == null || !wrapper.plugin.shouldBeForcefullyDoneOnMainThread(reloadable)) {
                            runnable.run();
                        } else {
                            try {
                                this.forcedMainThread = true;
                                this.forceMainThreadStopwatch.start();
                                InternalLogger.getInstance().warn("Forcing plugin " + wrapper.getPluginProviderName() + " to run on the main thread for " + sectionName + "! This is extremely dangerous, and have large performance implications.");
                                if (Platform.getEnvironment() == Env.CLIENT) {
                                    EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> this.queueExecutionClient(runnable));
                                } else {
                                    this.queueExecution(runnable);
                                }
                            }
                            finally {
                                this.forceMainThreadStopwatch.stop();
                            }
                        }
                    });
                }
                finally {
                    if (section == null) continue;
                    section.close();
                }
            }
            catch (Throwable throwable) {
                InternalLogger.getInstance().error(wrapper.getPluginProviderName() + " plugin failed to " + sectionName + "!", throwable);
            }
        }
    }

    private void queueExecution(Runnable runnable) {
        MinecraftServer server = GameInstance.getServer();
        if (server != null) {
            server.m_18709_(runnable);
        }
    }

    private void queueExecutionClient(Runnable runnable) {
        Minecraft.m_91087_().m_18709_(runnable);
    }

    @Override
    public void pre(ReloadStage stage) {
        this.forcedMainThread = false;
        this.forceMainThreadStopwatch.reset();
        this.reloadStopwatch.reset().start();
        this.observedStages.clear();
        this.observedStages.add(stage);
        ArrayList<PluginWrapper<P>> plugins = new ArrayList<PluginWrapper<P>>(this.getPluginWrapped().toList());
        plugins.sort(Comparator.comparingDouble(PluginWrapper::getPriority).reversed());
        Collections.reverse(plugins);
        try (SectionClosable preRegister = this.section(stage, "pre-register/");
             PerformanceLogger.Plugin perfLogger = RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.stage("Pre Registration");){
            this.pluginSection(stage, "pre-register/", plugins, null, (plugin, sink) -> {
                try (PerformanceLogger.Plugin.Inner inner = perfLogger.plugin(new Pair(plugin.provider, plugin.plugin));){
                    sink.accept(false, () -> plugin.plugin.preStage(this, stage));
                }
            });
        }
        catch (Throwable throwable) {
            new RuntimeException("Failed to run pre registration").printStackTrace();
        }
        this.reloadStopwatch.stop();
    }

    @Override
    public void post(ReloadStage stage) {
        this.reloadStopwatch.start();
        ArrayList<PluginWrapper<P>> plugins = new ArrayList<PluginWrapper<P>>(this.getPluginWrapped().toList());
        plugins.sort(Comparator.comparingDouble(PluginWrapper::getPriority).reversed());
        Collections.reverse(plugins);
        try (SectionClosable postRegister = this.section(stage, "post-register/");
             PerformanceLogger.Plugin perfLogger = RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.stage("Post Registration");){
            this.pluginSection(stage, "post-register/", plugins, null, (plugin, sink) -> {
                try (PerformanceLogger.Plugin.Inner inner = perfLogger.plugin(new Pair(plugin.provider, plugin.plugin));){
                    sink.accept(false, () -> plugin.plugin.postStage(this, stage));
                }
            });
        }
        catch (Throwable throwable) {
            new RuntimeException("Failed to run post registration").printStackTrace();
        }
        this.reloadStopwatch.stop();
        InternalLogger.getInstance().info("Reloaded Plugin Manager [%s] with %d plugins in %s.", this.pluginClass.getSimpleName(), plugins.size(), this.reloadStopwatch);
        if (this.forcedMainThread) {
            InternalLogger.getInstance().warn("Forcing plugins to run on main thread took " + this.forceMainThreadStopwatch);
        }
    }

    private static String name(Class<?> clazz) {
        String simpleName = clazz.getSimpleName();
        if (simpleName.isEmpty()) {
            return clazz.getName();
        }
        return simpleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startReload(ReloadStage stage) {
        try {
            PerformanceLogger.Plugin.Inner inner;
            this.reloadStopwatch.start();
            this.reloading = stage;
            try (SectionClosable startReloadAll = this.section(stage, "start-reload/");
                 PerformanceLogger.Plugin perfLogger = RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.stage("Reload Initialization");){
                for (Reloadable<P> reloadable : this.reloadables) {
                    Class<?> reloadableClass = reloadable.getClass();
                    try {
                        SectionClosable startReload = this.section(stage, "start-reload/" + PluginManagerImpl.name(reloadableClass) + "/");
                        try {
                            inner = perfLogger.stage(PluginManagerImpl.name(reloadableClass));
                            try {
                                reloadable.startReload(stage);
                            }
                            finally {
                                if (inner == null) continue;
                                inner.close();
                            }
                        }
                        finally {
                            if (startReload == null) continue;
                            startReload.close();
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            ArrayList<PluginWrapper<P>> plugins = new ArrayList<PluginWrapper<P>>(this.getPluginWrapped().toList());
            plugins.sort(Comparator.comparingDouble(PluginWrapper::getPriority).reversed());
            InternalLogger.getInstance().info("Reloading Plugin Manager [%s] stage [%s], registered %d plugins: %s", PluginManagerImpl.name(this.pluginClass), stage.toString(), plugins.size(), CollectionUtils.mapAndJoinToString(plugins, PluginWrapper::getPluginProviderName, (CharSequence)", "));
            Collections.reverse(plugins);
            for (Reloadable reloadable : this.getReloadables()) {
                Class<?> reloadableClass = reloadable.getClass();
                SectionClosable reloadablePlugin = this.section(stage, "reloadable-plugin/" + PluginManagerImpl.name(reloadableClass) + "/");
                try {
                    PerformanceLogger.Plugin perfLogger = RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.stage(PluginManagerImpl.name(reloadableClass));
                    try {
                        inner = perfLogger.stage("reloadable-plugin/" + PluginManagerImpl.name(reloadableClass) + "/prompt-others-before");
                        try {
                            for (Reloadable<P> listener : this.reloadables) {
                                try {
                                    listener.beforeReloadable(stage, reloadable);
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                            }
                        }
                        finally {
                            if (inner != null) {
                                inner.close();
                            }
                        }
                        this.pluginSection(stage, "reloadable-plugin/" + PluginManagerImpl.name(reloadableClass) + "/", plugins, reloadable, (plugin, sink) -> {
                            try (PerformanceLogger.Plugin.Inner inner = perfLogger.plugin(new Pair(plugin.provider, plugin.plugin));){
                                sink.accept(true, () -> {
                                    for (Reloadable listener : this.reloadables) {
                                        try {
                                            listener.beforeReloadablePlugin(stage, reloadable, plugin.plugin);
                                        }
                                        catch (Throwable throwable) {
                                            throwable.printStackTrace();
                                        }
                                    }
                                    try {
                                        reloadable.acceptPlugin(plugin.plugin, stage);
                                    }
                                    finally {
                                        for (Reloadable listener : this.reloadables) {
                                            try {
                                                listener.afterReloadablePlugin(stage, reloadable, plugin.plugin);
                                            }
                                            catch (Throwable throwable) {
                                                throwable.printStackTrace();
                                            }
                                        }
                                    }
                                });
                            }
                        });
                        inner = perfLogger.stage("reloadable-plugin/" + PluginManagerImpl.name(reloadableClass) + "/prompt-others-after");
                        try {
                            for (Reloadable<P> listener : this.reloadables) {
                                try {
                                    listener.afterReloadable(stage, reloadable);
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                            }
                        }
                        finally {
                            if (inner == null) continue;
                            inner.close();
                        }
                    }
                    finally {
                        if (perfLogger == null) continue;
                        perfLogger.close();
                    }
                }
                finally {
                    if (reloadablePlugin == null) continue;
                    reloadablePlugin.close();
                }
            }
            try (SectionClosable endReloadAll = this.section(stage, "end-reload/");
                 PerformanceLogger.Plugin plugin2 = RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.stage("Reload Finalization");){
                for (Reloadable<P> reloadable : this.reloadables) {
                    Class<?> reloadableClass = reloadable.getClass();
                    try {
                        SectionClosable endReload = this.section(stage, "end-reload/" + PluginManagerImpl.name(reloadableClass) + "/");
                        try {
                            PerformanceLogger.Plugin.Inner inner2 = plugin2.stage(PluginManagerImpl.name(reloadableClass));
                            try {
                                reloadable.endReload(stage);
                            }
                            finally {
                                if (inner2 == null) continue;
                                inner2.close();
                            }
                        }
                        finally {
                            if (endReload == null) continue;
                            endReload.close();
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            this.reloadStopwatch.stop();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            this.reloading = null;
        }
    }

    public List<ReloadStage> getObservedStages() {
        return this.observedStages;
    }

    private static class SectionClosable
    implements Closeable {
        private ReloadStage stage;
        private MutablePair<Stopwatch, String> sectionData;

        public SectionClosable(ReloadStage stage, String section) {
            this.stage = stage;
            this.sectionData = new MutablePair((Object)Stopwatch.createUnstarted(), (Object)"");
            this.sectionData.setRight((Object)section);
            InternalLogger.getInstance().trace("[" + stage + "] Reloading Section: \"%s\"", section);
            ((Stopwatch)this.sectionData.getLeft()).reset().start();
        }

        @Override
        public void close() {
            ((Stopwatch)this.sectionData.getLeft()).stop();
            String section = (String)this.sectionData.getRight();
            InternalLogger.getInstance().trace("[" + this.stage + "] Reloading Section: \"%s\" done in %s", section, ((Stopwatch)this.sectionData.getLeft()).toString());
            ((Stopwatch)this.sectionData.getLeft()).reset();
        }
    }

    private static class PluginWrapper<P extends REIPlugin<?>> {
        private final P plugin;
        private final REIPluginProvider<P> provider;

        public PluginWrapper(P plugin, REIPluginProvider<P> provider) {
            this.plugin = plugin;
            this.provider = provider;
        }

        public double getPriority() {
            return this.plugin.getPriority();
        }

        public String getPluginProviderName() {
            return this.provider.getPluginProviderName();
        }
    }

    @FunctionalInterface
    private static interface SectionPluginSink {
        public void accept(boolean var1, Runnable var2);
    }
}

