/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.type;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryList;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryListener;
import me.shedaniel.rei.impl.common.entry.type.NormalEntryRegistryList;
import me.shedaniel.rei.impl.common.entry.type.PreFilteredEntryList;
import me.shedaniel.rei.impl.common.entry.type.ReloadingEntryRegistryList;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class EntryRegistryImpl
implements EntryRegistry {
    public List<EntryRegistryListener> listeners = Lists.newCopyOnWriteArrayList();
    private PreFilteredEntryList preFilteredList;
    private EntryRegistryList registryList = new NormalEntryRegistryList();
    private LongSet entriesHash = new LongOpenHashSet();
    private boolean reloading;
    private static final Comparator<ItemStack> STACK_COMPARATOR = (a, b) -> ItemStack.m_41728_((ItemStack)a, (ItemStack)b) ? 0 : 1;

    public EntryRegistryImpl() {
        this.preFilteredList = new PreFilteredEntryList(this);
        this.listeners.add(this.preFilteredList);
    }

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerEntries(this);
    }

    @Override
    public ReloadStage getStage() {
        return ReloadStage.START;
    }

    @Override
    public void startReload() {
        this.listeners.clear();
        this.registryList = new ReloadingEntryRegistryList();
        this.entriesHash = new LongOpenHashSet();
        this.preFilteredList = new PreFilteredEntryList(this);
        this.listeners.add(this.preFilteredList);
        this.reloading = true;
    }

    @Override
    public void endReload() {
        this.reloading = false;
        if (!(this.registryList instanceof ReloadingEntryRegistryList)) {
            throw new IllegalStateException("Expected ReloadingEntryRegistryList, got " + this.registryList.getClass().getName());
        }
        this.registryList = new NormalEntryRegistryList(this.registryList.stream().filter(((Predicate<EntryStack>)EntryStack::isEmpty).negate()));
        this.refilter();
        REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
        InternalLogger.getInstance().debug("Reloaded entry registry with %d entries and %d filtered entries", this.size(), this.getPreFilteredList().size());
    }

    @Override
    public boolean isReloading() {
        return this.reloading;
    }

    @Override
    public int size() {
        return this.registryList.size();
    }

    @Override
    public Stream<EntryStack<?>> getEntryStacks() {
        return this.registryList.stream();
    }

    @Override
    public List<EntryStack<?>> getPreFilteredList() {
        return Collections.unmodifiableList(this.preFilteredList.getList());
    }

    @Override
    public void refilter() {
        List<EntryStack<?>> stacks = this.registryList.collect();
        for (EntryRegistryListener listener : this.listeners) {
            listener.onReFilter(stacks);
        }
    }

    @Override
    public List<ItemStack> appendStacksForItem(Item item) {
        NonNullList list = NonNullList.m_122779_();
        LongOpenHashSet set = new LongOpenHashSet();
        EntryDefinition<ItemStack> itemDefinition = VanillaEntryTypes.ITEM.getDefinition();
        for (CreativeModeTab tab : CreativeModeTab.f_40748_) {
            if (tab == CreativeModeTab.f_40760_ || tab == CreativeModeTab.f_40761_) continue;
            NonNullList tabList = NonNullList.m_122779_();
            item.m_6787_(tab, tabList);
            for (ItemStack stack : tabList) {
                if (!set.add(itemDefinition.hash(null, stack, ComparisonContext.EXACT))) continue;
                list.add((Object)stack);
            }
        }
        if (list.isEmpty()) {
            return Collections.singletonList(item.m_7968_());
        }
        if (list.size() > 1) {
            list.sort(STACK_COMPARATOR);
        }
        return list;
    }

    @Override
    @ApiStatus.Internal
    public Collection<EntryStack<?>> refilterNew(boolean warn, Collection<EntryStack<?>> entries) {
        return this.preFilteredList.refilterNew(warn, entries);
    }

    @Override
    public boolean alreadyContain(EntryStack<?> stack) {
        return this.entriesHash.contains(EntryStacks.hashExact(stack));
    }

    @Override
    public void addEntryAfter(@Nullable EntryStack<?> afterEntry, EntryStack<?> stack) {
        long hashExact = EntryStacks.hashExact(stack);
        if (this.entriesHash.add(hashExact)) {
            if (afterEntry != null) {
                int index = this.registryList.lastIndexOf(afterEntry);
                this.registryList.add(index, stack, hashExact);
            } else {
                this.registryList.add(stack, hashExact);
            }
            for (EntryRegistryListener listener : this.listeners) {
                listener.addEntryAfter(afterEntry, stack, hashExact);
            }
        }
    }

    @Override
    public void addEntriesAfter(@Nullable EntryStack<?> afterEntry, Collection<? extends EntryStack<?>> stacks) {
        ArrayList<EntryStack<?>> filtered;
        LongArrayList hashes;
        LongArrayList longArrayList = hashes = this.registryList.needsHash() ? new LongArrayList(stacks.size()) : null;
        if (this.registryList.needsHash()) {
            filtered = new ArrayList(stacks.size());
            for (EntryStack<?> stack : stacks) {
                long hashExact = EntryStacks.hashExact(stack);
                if (!this.entriesHash.add(hashExact)) continue;
                filtered.add(stack);
                hashes.add(hashExact);
            }
        } else {
            filtered = CollectionUtils.filterToList((List)stacks, entry -> this.entriesHash.add(EntryStacks.hashExact(entry)));
        }
        if (afterEntry != null) {
            int index = this.registryList.lastIndexOf(afterEntry);
            this.registryList.addAll(index, filtered, (LongList)hashes);
        } else {
            this.registryList.addAll(filtered, (LongList)hashes);
        }
        for (EntryRegistryListener listener : this.listeners) {
            listener.addEntriesAfter(afterEntry, filtered, (LongList)hashes);
        }
    }

    @Override
    public boolean removeEntry(EntryStack<?> stack) {
        long hashExact = EntryStacks.hashExact(stack);
        this.registryList.remove(stack, hashExact);
        boolean removed = this.entriesHash.remove(hashExact);
        if (removed) {
            for (EntryRegistryListener listener : this.listeners) {
                listener.removeEntry(stack, hashExact);
            }
        }
        return removed;
    }

    @Override
    public boolean removeEntryIf(Predicate<? extends EntryStack<?>> predicate) {
        ArrayList removedStacks = new ArrayList();
        LongArrayList hashes = this.registryList.needsHash() ? new LongArrayList() : null;
        boolean removed = this.registryList.removeIf(arg_0 -> this.lambda$removeEntryIf$2(predicate, removedStacks, (LongList)hashes, arg_0));
        if (removed) {
            for (EntryRegistryListener listener : this.listeners) {
                listener.removeEntries(removedStacks, (LongList)hashes);
            }
        }
        return removed;
    }

    @Override
    public boolean removeEntryExactHashIf(LongPredicate predicate) {
        LongPredicate entryStackPredicate = hash -> {
            if (predicate.test(hash)) {
                this.entriesHash.remove(hash);
                return true;
            }
            return false;
        };
        for (EntryRegistryListener listener : this.listeners) {
            listener.removeEntriesIf(stack -> predicate.test(EntryStacks.hashExact(stack)));
        }
        return this.registryList.removeExactIf(entryStackPredicate);
    }

    @Override
    public boolean removeEntryFuzzyHashIf(LongPredicate predicate) {
        Predicate<EntryStack<?>> entryStackPredicate = stack -> {
            if (predicate.test(EntryStacks.hashFuzzy(stack))) {
                this.entriesHash.remove(EntryStacks.hashExact(stack));
                return true;
            }
            return false;
        };
        for (EntryRegistryListener listener : this.listeners) {
            listener.removeEntriesIf(entryStackPredicate);
        }
        return this.registryList.removeIf(entryStackPredicate);
    }

    private /* synthetic */ boolean lambda$removeEntryIf$2(Predicate predicate, List removedStacks, LongList hashes, EntryStack stack) {
        if (predicate.test(stack)) {
            long hashExact = EntryStacks.hashExact(stack);
            this.entriesHash.remove(hashExact);
            removedStacks.add(stack);
            if (hashes != null) {
                hashes.add(hashExact);
            }
            return true;
        }
        return false;
    }
}

