/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.method;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.search.method.InputMethod;
import me.shedaniel.rei.api.client.search.method.InputMethodRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.search.method.DefaultInputMethod;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class InputMethodRegistryImpl
implements InputMethodRegistry {
    private final Map<ResourceLocation, InputMethod<?>> inputMethods = Maps.newHashMap();

    @Override
    public void add(ResourceLocation id, InputMethod<?> inputMethod) {
        this.inputMethods.put(id, inputMethod);
        InternalLogger.getInstance().debug("Added input method [%s]: %s", id, inputMethod.getName().getString());
    }

    @Override
    @Nullable
    public InputMethod<?> get(@Nullable ResourceLocation id) {
        if (id == null) {
            return null;
        }
        return this.inputMethods.get(id);
    }

    @Override
    public InputMethod<?> getOrDefault(@Nullable ResourceLocation id) {
        return Objects.requireNonNullElse(this.get(id), DefaultInputMethod.INSTANCE);
    }

    @Override
    public Map<ResourceLocation, InputMethod<?>> getAll() {
        return Collections.unmodifiableMap(this.inputMethods);
    }

    @Override
    public void startReload() {
        this.inputMethods.clear();
    }

    @Override
    public void endReload() {
        InputMethod<?> active = InputMethod.active();
        String languageCode = Minecraft.m_91087_().f_91066_.f_92075_;
        if (!CollectionUtils.anyMatch(active.getMatchingLocales(), locale -> locale.code().equals(languageCode))) {
            InternalLogger.getInstance().error("Reset active input method because the language code {} is not supported by the active input method.", languageCode);
            ConfigManagerImpl.getInstance().getConfig().setInputMethodId(new ResourceLocation("rei:default"));
            return;
        }
        ExecutorService service = Executors.newSingleThreadExecutor();
        ((CompletableFuture)active.prepare(service).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                InternalLogger.getInstance().error("Failed to prepare input method", (Throwable)throwable);
                ConfigManagerImpl.getInstance().getConfig().setInputMethodId(new ResourceLocation("rei:default"));
                ExecutorService service2 = Executors.newSingleThreadExecutor();
                ((CompletableFuture)active.dispose(service2).whenComplete((unused2, throwable2) -> {
                    if (throwable2 != null) {
                        InternalLogger.getInstance().error("Failed to dispose input method", (Throwable)throwable2);
                    }
                })).join();
                service2.shutdown();
            }
        })).join();
        service.shutdown();
        InternalLogger.getInstance().debug("Registered %d input methods: ", this.inputMethods.size(), this.inputMethods.values().stream().map(inputMethod -> inputMethod.getName().getString()).collect(Collectors.joining(", ")));
    }

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerInputMethods(this);
    }
}

