/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.favorites.listeners;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesEntriesManager;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.client.gui.widget.region.RealRegionEntry;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionEntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionListener;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

public class FavoritesRegionListener
implements RegionListener<FavoriteEntry> {
    private final FavoritesListWidget favoritesListWidget;

    public FavoritesRegionListener(FavoritesListWidget favoritesListWidget) {
        this.favoritesListWidget = favoritesListWidget;
    }

    @Override
    public void onDrop(Stream<FavoriteEntry> entries) {
        if (ConfigObject.getInstance().isFavoritesEnabled()) {
            FavoritesEntriesManager.INSTANCE.setEntries(entries.collect(Collectors.toList()));
        }
    }

    @Override
    public void onRemove(RealRegionEntry<FavoriteEntry> entry) {
        if (ConfigObject.getInstance().isFavoritesEnabled()) {
            FavoritesEntriesManager.INSTANCE.remove(entry.getEntry());
        }
    }

    @Override
    public void onConsumed(RealRegionEntry<FavoriteEntry> entry) {
        this.favoritesListWidget.setSystemRegionEntries(entry);
    }

    @Override
    @Nullable
    public FavoriteEntry convertDraggableStack(DraggingContext<Screen> context, DraggableStack stack) {
        return FavoriteEntry.fromEntryStack(stack.getStack().copy());
    }

    @Override
    public void onSetNewEntries(List<RegionEntryWidget<FavoriteEntry>> regionEntryListEntries) {
        this.favoritesListWidget.setSystemRegionEntries(null);
    }
}

