/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.entrylist;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.FloatingRectangle;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.widget.CachedEntryListRender;
import me.shedaniel.rei.impl.client.gui.widget.DisplayedEntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.CollapsedEntriesTooltip;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.CollapsingEntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsedStack;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class EntryListStackEntry
extends DisplayedEntryWidget {
    private final CollapsingEntryListWidget parent;
    public EntryStack<?> our;
    private NumberAnimator<Double> size = null;
    private CollapsedStack collapsedStack = null;
    private List<FloatingRectangle> collapsedBounds = null;

    public EntryListStackEntry(CollapsingEntryListWidget parent, int x, int y, int entrySize, boolean zoomed) {
        super(new Point(x, y), entrySize);
        this.parent = parent;
        if (zoomed) {
            this.noHighlight();
            this.size = ValueAnimator.ofDouble((double)1.0).withConvention(() -> {
                double mouseX = PointHelper.getMouseFloatingX();
                double mouseY = PointHelper.getMouseFloatingY();
                int x1 = this.getBounds().getCenterX() - entrySize / 2;
                int y1 = this.getBounds().getCenterY() - entrySize / 2;
                boolean hovering = mouseX >= (double)x1 && mouseX < (double)(x1 + entrySize) && mouseY >= (double)y1 && mouseY < (double)(y1 + entrySize);
                return hovering ? 1.5 : 1.0;
            }, 200L);
        }
    }

    @Override
    protected void drawExtra(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.size != null) {
            this.size.update((double)delta);
            int centerX = this.getBounds().getCenterX();
            int centerY = this.getBounds().getCenterY();
            int entrySize = (int)Math.round((double)EntryListWidget.entrySize() * (Double)this.size.value());
            this.getBounds().setBounds(centerX - entrySize / 2, centerY - entrySize / 2, entrySize, entrySize);
        }
        super.drawExtra(matrices, mouseX, mouseY, delta);
    }

    @Override
    public EntryStack<?> getCurrentEntry() {
        if (this.our != null && CachedEntryListRender.cachedTextureLocation != null) {
            return this.our;
        }
        return super.getCurrentEntry();
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return super.containsMouse(mouseX, mouseY) && this.parent.containsChecked(mouseX, mouseY, true);
    }

    @Override
    protected void drawBackground(PoseStack matrices, int mouseX, int mouseY, float delta) {
        Rectangle bounds = this.getBounds();
        if (this.collapsedStack != null) {
            this.m_93179_(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), 0x34FFFFFF, 0x34FFFFFF);
        }
        super.drawBackground(matrices, mouseX, mouseY, delta);
    }

    @Override
    protected void drawCurrentEntry(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.collapsedStack != null && !this.collapsedStack.isExpanded()) {
            Rectangle bounds = this.getBounds();
            List<EntryStack<?>> stacks = this.collapsedStack.getIngredient();
            float fullSize = bounds.getWidth();
            matrices.m_85836_();
            matrices.m_85837_(0.0, 0.0, 10.0);
            for (int i = stacks.size() - 1; i >= 0; --i) {
                EntryStack<?> stack = stacks.get(i);
                if (i >= this.collapsedBounds.size()) continue;
                FloatingRectangle value = this.collapsedBounds.get(i);
                double x = (double)bounds.x + value.x * (double)fullSize;
                double y = (double)bounds.y + value.y * (double)fullSize;
                double scaledSize = value.width * (double)fullSize;
                stack.render(matrices, new Rectangle(x - scaledSize / 2.0, y - scaledSize / 2.0, scaledSize, scaledSize), mouseX, mouseY, delta);
                matrices.m_85837_(0.0, 0.0, 10.0);
            }
            matrices.m_85849_();
        } else {
            super.drawCurrentEntry(matrices, mouseX, mouseY, delta);
        }
    }

    @Override
    protected boolean doAction(double mouseX, double mouseY, int button) {
        if (this.collapsedStack != null) {
            ++this.parent.updatedCount;
            this.collapsedStack.setExpanded(!this.collapsedStack.isExpanded());
            this.parent.updateEntriesPosition();
            Widgets.produceClickSound();
            return true;
        }
        return super.doAction(mouseX, mouseY, button);
    }

    public void collapsed(CollapsedStack collapsedStack) {
        List<EntryStack<?>> ingredient;
        this.collapsedStack = collapsedStack;
        this.collapsedBounds = collapsedStack == null ? null : ((ingredient = collapsedStack.getIngredient()).size() == 0 ? null : (ingredient.size() == 1 ? List.of(new FloatingRectangle(0.0, 0.0, 1.0, 1.0)) : List.of(new FloatingRectangle(0.44, 0.56, 0.9, 0.8), new FloatingRectangle(0.56, 0.44, 0.9, 0.8))));
    }

    @Override
    @Nullable
    public Tooltip getCurrentTooltip(Point point) {
        if (this.collapsedStack != null && !this.collapsedStack.isExpanded()) {
            Tooltip tooltip = Tooltip.create(point, new Component[]{new TranslatableComponent("text.rei.collapsed.entry", new Object[]{this.collapsedStack.getName()})});
            tooltip.add(new CollapsedEntriesTooltip(this.collapsedStack));
            tooltip.add((Component)new TranslatableComponent("text.rei.collapsed.entry.hint.expand", new Object[]{this.collapsedStack.getName(), this.collapsedStack.getIngredient().size()}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            ClientHelper.getInstance().appendModIdToTooltips(tooltip, this.collapsedStack.getModId());
            return tooltip;
        }
        Tooltip tooltip = super.getCurrentTooltip(point);
        if (tooltip != null && this.collapsedStack != null) {
            tooltip.entries().add(Mth.m_14045_((int)(tooltip.entries().size() - 1), (int)0, (int)(tooltip.entries().size() - 1)), Tooltip.entry((Component)new TranslatableComponent("text.rei.collapsed.entry.hint.collapse", new Object[]{this.collapsedStack.getName(), this.collapsedStack.getIngredient().size()}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC})));
        }
        return tooltip;
    }

    @Nullable
    public CollapsedStack getCollapsedStack() {
        return this.collapsedStack;
    }

    @Override
    protected long getCyclingInterval() {
        return 100L;
    }
}

