/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.gui.config.SearchFieldLocation;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.search.method.InputMethod;
import me.shedaniel.rei.api.client.search.method.InputMethodRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.modules.MenuAccess;
import me.shedaniel.rei.impl.client.gui.modules.MenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.SubMenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.ToggleMenuEntry;
import me.shedaniel.rei.impl.client.gui.screen.ConfigReloadingScreen;
import me.shedaniel.rei.impl.client.gui.widget.InternalWidgets;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class CraftableFilterButtonWidget {
    public static final UUID FILTER_MENU_UUID = UUID.fromString("2839e998-1679-4f9e-a257-37411d16f1e6");

    public static Widget create(ScreenOverlayImpl overlay) {
        Rectangle bounds = CraftableFilterButtonWidget.getCraftableFilterBounds();
        MenuAccess access = overlay.menuAccess();
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemStack icon = new ItemStack((ItemLike)Blocks.f_50091_);
        Button filterButton = Widgets.createButton(bounds, NarratorChatListener.f_93310_).focusable(false).onClick(button -> {
            ConfigManager.getInstance().toggleCraftableOnly();
            ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
        }).onRender((matrices, button) -> {
            button.setTint(ConfigManager.getInstance().isCraftableOnlyEnabled() ? 939579655 : 956235776);
            access.openOrClose(FILTER_MENU_UUID, button.getBounds(), CraftableFilterButtonWidget::menuEntries);
        }).containsMousePredicate((button, point) -> button.getBounds().contains(point) && overlay.isNotInExclusionZones(point.x, point.y)).tooltipLineSupplier(button -> new TranslatableComponent(ConfigManager.getInstance().isCraftableOnlyEnabled() ? "text.rei.showing_craftable" : "text.rei.showing_all"));
        Widget overlayWidget = Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            Vector4f vector = new Vector4f((float)(bounds.x + 2), (float)(bounds.y + 2), (float)(helper.m_93252_() - 10), 1.0f);
            vector.m_123607_(matrices.m_85850_().m_85861_());
            itemRenderer.f_115093_ = vector.m_123616_();
            itemRenderer.m_115123_(icon, (int)vector.m_123601_(), (int)vector.m_123615_());
            itemRenderer.f_115093_ = 0.0f;
        });
        return InternalWidgets.wrapLateRenderable(Widgets.concat(filterButton, overlayWidget));
    }

    private static Collection<MenuEntry> menuEntries() {
        ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
        ArrayList<MenuEntry> entries = new ArrayList<MenuEntry>(List.of(new SubMenuEntry((Component)new TranslatableComponent("text.rei.config.menu.search_field.position"), Arrays.stream(SearchFieldLocation.values()).map(location -> ToggleMenuEntry.of((Component)new TextComponent(location.toString()), () -> config.getSearchFieldLocation() == location, bool -> config.setSearchFieldLocation((SearchFieldLocation)((Object)location))).withActive(() -> config.getSearchFieldLocation() != location)).toList())));
        List<Map.Entry<ResourceLocation, InputMethod<?>>> applicableInputMethods = CraftableFilterButtonWidget.getApplicableInputMethods();
        if (applicableInputMethods.size() > 1) {
            entries.add(new SubMenuEntry((Component)new TranslatableComponent("text.rei.config.menu.search_field.input_method"), CraftableFilterButtonWidget.createInputMethodEntries(applicableInputMethods)));
        }
        return entries;
    }

    public static List<Map.Entry<ResourceLocation, InputMethod<?>>> getApplicableInputMethods() {
        String languageCode = Minecraft.m_91087_().f_91066_.f_92075_;
        return InputMethodRegistry.getInstance().getAll().entrySet().stream().filter(entry -> CollectionUtils.anyMatch(((InputMethod)entry.getValue()).getMatchingLocales(), locale -> locale.code().equals(languageCode))).toList();
    }

    public static List<MenuEntry> createInputMethodEntries(List<Map.Entry<ResourceLocation, InputMethod<?>>> applicableInputMethods) {
        ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
        return applicableInputMethods.stream().map(pair -> ToggleMenuEntry.of(((InputMethod)pair.getValue()).getName(), () -> Objects.equals(config.getInputMethodId(), pair.getKey()), bool -> {
            ExecutorService service = Executors.newSingleThreadExecutor();
            InputMethod<?> active = InputMethod.active();
            ((CompletableFuture)active.dispose(service).whenComplete((unused, throwable) -> {
                if (throwable != null) {
                    InternalLogger.getInstance().error("Failed to dispose input method", (Throwable)throwable);
                }
                ConfigManagerImpl.getInstance().getConfig().setInputMethodId(new ResourceLocation("rei:default"));
            })).join();
            CompletionStage future = ((InputMethod)pair.getValue()).prepare(service).whenComplete((unused, throwable) -> {
                if (throwable != null) {
                    InternalLogger.getInstance().error("Failed to prepare input method", (Throwable)throwable);
                    ConfigManagerImpl.getInstance().getConfig().setInputMethodId(new ResourceLocation("rei:default"));
                } else {
                    ConfigManagerImpl.getInstance().getConfig().setInputMethodId((ResourceLocation)pair.getKey());
                }
            });
            Screen screen = Minecraft.m_91087_().f_91080_;
            Minecraft.m_91087_().m_91152_((Screen)new ConfigReloadingScreen((Component)new TranslatableComponent("text.rei.input.methods.initializing"), () -> CraftableFilterButtonWidget.lambda$createInputMethodEntries$14((CompletableFuture)future), () -> Minecraft.m_91087_().m_91152_(screen)));
            ((CompletableFuture)future).whenComplete((unused, throwable) -> service.shutdown());
        }).withActive(() -> !Objects.equals(config.getInputMethodId(), pair.getKey())).withTooltip(() -> Tooltip.create(Widget.mouse(), ((InputMethod)pair.getValue()).getDescription()))).toList();
    }

    private static Rectangle getCraftableFilterBounds() {
        Rectangle area = REIRuntimeImpl.getSearchField().getBounds().clone();
        area.setLocation(area.x + area.width + 4, area.y - 1);
        area.setSize(20, 20);
        return area;
    }

    private static /* synthetic */ boolean lambda$createInputMethodEntries$14(CompletableFuture future) {
        return !future.isDone();
    }
}

