/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.entry.filtering.rules;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.search.SearchFilter;
import me.shedaniel.rei.api.client.search.SearchProvider;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.entries.FilteringEntry;
import me.shedaniel.rei.impl.client.config.entries.FilteringRuleOptionsScreen;
import me.shedaniel.rei.impl.client.entry.filtering.AbstractFilteringRule;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringCache;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContext;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringResult;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.StringUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SearchFilteringRule
extends AbstractFilteringRule<SearchFilteringRule> {
    private String filterStr;
    private Supplier<SearchFilter> filter;
    private boolean show;

    public SearchFilteringRule() {
    }

    public SearchFilteringRule(String filter, boolean show) {
        this.setFilter(filter);
        this.show = show;
    }

    public void setFilter(String filter) {
        this.filterStr = filter;
        this.filter = Suppliers.memoize(() -> StringUtil.m_14408_((String)filter) ? SearchFilter.matchAll() : SearchProvider.getInstance().createFilter(filter));
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag.m_128359_("filter", this.filterStr);
        tag.m_128379_("show", this.show);
        return tag;
    }

    @Override
    public SearchFilteringRule createFromTag(CompoundTag tag) {
        String filter = tag.m_128461_("filter");
        boolean show = tag.m_128471_("show");
        return new SearchFilteringRule(filter, show);
    }

    @Override
    public FilteringResult processFilteredStacks(FilteringContext context, FilteringCache cache, boolean async) {
        ArrayList completableFutures = Lists.newArrayList();
        this.processList(context.getUnsetStacks(), completableFutures);
        if (this.show) {
            this.processList(context.getHiddenStacks(), completableFutures);
        } else {
            this.processList(context.getShownStacks(), completableFutures);
        }
        try {
            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
        FilteringResult result = FilteringResult.create();
        for (CompletableFuture future : completableFutures) {
            List now = future.getNow(null);
            if (now == null) continue;
            if (this.show) {
                result.show(now);
                continue;
            }
            result.hide(now);
        }
        return result;
    }

    @Override
    public SearchFilteringRule createNew() {
        return new SearchFilteringRule("", false);
    }

    private void processList(Collection<EntryStack<?>> stacks, List<CompletableFuture<List<EntryStack<?>>>> completableFutures) {
        for (Iterable iterable : CollectionUtils.partition((List)stacks, 100)) {
            completableFutures.add(CompletableFuture.supplyAsync(() -> {
                ArrayList output = Lists.newArrayList();
                for (EntryStack stack : partitionStacks) {
                    if (stack == null || !this.filter.get().test(stack)) continue;
                    output.add(stack);
                }
                return output;
            }));
        }
    }

    @Override
    public Component getTitle() {
        return new TranslatableComponent("rule.roughlyenoughitems.filtering.search");
    }

    @Override
    public Component getSubtitle() {
        return new TranslatableComponent("rule.roughlyenoughitems.filtering.search.subtitle");
    }

    @Override
    public Optional<BiFunction<FilteringEntry, Screen, Screen>> createEntryScreen() {
        return Optional.of((entry, screen) -> new FilteringRuleOptionsScreen<SearchFilteringRule>(entry, this, screen){
            FilteringRuleOptionsScreen.TextFieldRuleEntry entry;
            FilteringRuleOptionsScreen.BooleanRuleEntry show;
            List<EntryWidget> entryStacks;
            {
                this.entry = null;
                this.show = null;
                this.entryStacks = new ArrayList<EntryWidget>();
            }

            @Override
            public void addEntries(Consumer<FilteringRuleOptionsScreen.RuleEntry> entryConsumer) {
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (FormattedText)new TranslatableComponent("rule.roughlyenoughitems.filtering.search.filter").m_130940_(ChatFormatting.GRAY));
                this.entry = new FilteringRuleOptionsScreen.TextFieldRuleEntry(this.f_96543_ - 36, this.rule, widget -> {
                    widget.m_94199_(9999);
                    widget.m_94151_(searchTerm -> {
                        SearchFilter filter = SearchProvider.getInstance().createFilter((String)searchTerm);
                        this.entryStacks = ((Stream)EntryRegistry.getInstance().getEntryStacks().parallel()).filter(filter).map(EntryStack::normalize).map(stack -> new EntryWidget(new Rectangle(0, 0, 18, 18)).noBackground().entry((EntryStack)stack)).collect(Collectors.toList());
                    });
                    if (this.entry != null) {
                        widget.m_94144_(this.entry.getWidget().m_94155_());
                    } else {
                        widget.m_94144_(((SearchFilteringRule)this.rule).filterStr);
                    }
                });
                entryConsumer.accept(this.entry);
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (FormattedText)new TranslatableComponent("rule.roughlyenoughitems.filtering.search.show").m_130940_(ChatFormatting.GRAY));
                Function<Boolean, Component> function = bool -> new TranslatableComponent("rule.roughlyenoughitems.filtering.search.show." + bool);
                this.show = new FilteringRuleOptionsScreen.BooleanRuleEntry(this.f_96543_ - 36, this.show == null ? ((SearchFilteringRule)this.rule).show : this.show.getBoolean(), this.rule, function);
                entryConsumer.accept(this.show);
                this.addEmpty(entryConsumer, 10);
                entryConsumer.accept(new FilteringRuleOptionsScreen.SubRulesEntry(this.rule, () -> (Component)function.apply(this.show == null ? ((SearchFilteringRule)this.rule).show : this.show.getBoolean()), Collections.singletonList(new EntryStacksRuleEntry((SearchFilteringRule)this.rule, () -> this.entryStacks, this.entry, this.show))));
            }

            @Override
            public void save() {
                ((SearchFilteringRule)this.rule).setFilter(this.entry.getWidget().m_94155_());
                ((SearchFilteringRule)this.rule).show = this.show.getBoolean();
            }
        });
    }

    public static class EntryStacksRuleEntry
    extends FilteringRuleOptionsScreen.RuleEntry {
        private final Supplier<List<EntryWidget>> entryStacks;
        private int totalHeight;

        public EntryStacksRuleEntry(SearchFilteringRule rule, Supplier<List<EntryWidget>> entryStacks, FilteringRuleOptionsScreen.TextFieldRuleEntry entry, FilteringRuleOptionsScreen.BooleanRuleEntry show) {
            super(rule);
            this.entryStacks = entryStacks;
        }

        public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            BatchedEntryRendererManager manager = new BatchedEntryRendererManager();
            int entrySize = EntryListWidget.entrySize();
            int width = entryWidth / entrySize;
            int i = 0;
            for (EntryWidget stack : this.entryStacks.get()) {
                stack.getBounds().setLocation(x + i % width * entrySize, y + i / width * entrySize);
                if (stack.getBounds().getMaxY() >= 0 && stack.getBounds().getY() <= Minecraft.m_91087_().m_91268_().m_85446_()) {
                    manager.add(stack);
                }
                ++i;
            }
            manager.render(matrices, mouseX, mouseY, delta);
            this.totalHeight = (i / width + 1) * entrySize;
        }

        public int getItemHeight() {
            return this.totalHeight;
        }

        public List<? extends NarratableEntry> narratables() {
            return Lists.newArrayList();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Lists.newArrayList();
        }
    }
}

