/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.entry.filtering;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Optional;
import java.util.function.BiFunction;
import me.shedaniel.rei.impl.client.config.entries.FilteringEntry;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringCache;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContext;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringResult;
import me.shedaniel.rei.impl.client.entry.filtering.rules.ManualFilteringRule;
import me.shedaniel.rei.impl.client.entry.filtering.rules.SearchFilteringRule;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
@ApiStatus.Experimental
public interface FilteringRule<T extends FilteringRule<?>> {
    public static final BiMap<ResourceLocation, FilteringRule<?>> REGISTRY = (BiMap)Util.m_137469_((Object)HashBiMap.create(), registry -> {
        registry.put((Object)new ResourceLocation("roughlyenoughitems", "search"), (Object)new SearchFilteringRule());
        registry.put((Object)new ResourceLocation("roughlyenoughitems", "manual"), (Object)new ManualFilteringRule());
    });

    public static CompoundTag save(FilteringRule<?> rule, CompoundTag tag) {
        tag.m_128359_("id", ((ResourceLocation)REGISTRY.inverse().get(rule)).toString());
        tag.m_128365_("rule", (Tag)rule.save(new CompoundTag()));
        return tag;
    }

    public static FilteringRule<?> read(CompoundTag tag) {
        return ((FilteringRule)REGISTRY.get((Object)ResourceLocation.m_135820_((String)tag.m_128461_("id")))).createFromTag(tag.m_128469_("rule"));
    }

    public CompoundTag save(CompoundTag var1);

    public T createFromTag(CompoundTag var1);

    public FilteringResult processFilteredStacks(FilteringContext var1, FilteringCache var2, boolean var3);

    @ApiStatus.Internal
    default public Optional<BiFunction<FilteringEntry, Screen, Screen>> createEntryScreen() {
        return Optional.empty();
    }

    default public Component getTitle() {
        return Component.m_130674_((String)((ResourceLocation)REGISTRY.inverse().get((Object)this)).toString());
    }

    default public Component getSubtitle() {
        return Component.m_130674_(null);
    }

    default public Object prepareCache(boolean async) {
        return null;
    }

    public T createNew();
}

