/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.transfer;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class RecipeFinder {
    public final Int2IntMap idToAmountMap = new Int2IntOpenHashMap();

    public static int getItemId(ItemStack stack) {
        return Registry.f_122827_.m_7447_((Object)stack.m_41720_());
    }

    public static ItemStack getStackFromId(int itemId) {
        return itemId == 0 ? ItemStack.f_41583_ : new ItemStack((ItemLike)Item.m_41445_((int)itemId));
    }

    public void addNormalItem(ItemStack stack) {
        if (!(stack.m_41768_() || stack.m_41793_() || stack.m_41788_())) {
            this.addItem(stack);
        }
    }

    public void addItem(ItemStack stack) {
        this.addItem(stack, 64);
    }

    public void addItem(ItemStack stack, int count) {
        if (!stack.m_41619_()) {
            int itemId = RecipeFinder.getItemId(stack);
            int itemCount = Math.min(count, stack.m_41613_());
            this.addItem(itemId, itemCount);
        }
    }

    public boolean contains(int itemId) {
        return this.idToAmountMap.get(itemId) > 0;
    }

    public int take(int itemId, int amount) {
        int mapAmount = this.idToAmountMap.get(itemId);
        if (mapAmount >= amount) {
            this.idToAmountMap.put(itemId, mapAmount - amount);
            return itemId;
        }
        return 0;
    }

    private void addItem(int itemId, int itemCount) {
        this.idToAmountMap.put(itemId, this.idToAmountMap.get(itemId) + itemCount);
    }

    public boolean findRecipe(NonNullList<Ingredient> ingredients, @Nullable IntList intList_1) {
        return this.findRecipe(ingredients, intList_1, 1);
    }

    public boolean findRecipe(NonNullList<Ingredient> ingredients, @Nullable IntList intList_1, int int_1) {
        return new Filter(ingredients).find(int_1, intList_1);
    }

    public int countRecipeCrafts(NonNullList<Ingredient> ingredients, @Nullable IntList intList_1) {
        return this.countRecipeCrafts(ingredients, Integer.MAX_VALUE, intList_1);
    }

    public int countRecipeCrafts(NonNullList<Ingredient> ingredients, int int_1, @Nullable IntList intList_1) {
        return new Filter(ingredients).countCrafts(int_1, intList_1);
    }

    public void clear() {
        this.idToAmountMap.clear();
    }

    class Filter {
        private final List<Ingredient> ingredients = Lists.newArrayList();
        private final int ingredientCount;
        private final int[] usableIngredientItemIds;
        private final int usableIngredientSize;
        private final BitSet bitSet;
        private final IntList field_7557 = new IntArrayList();
        private final NonNullList<Ingredient> ingredientsInput;

        public Filter(NonNullList<Ingredient> ingredientsInput) {
            this.ingredientsInput = ingredientsInput;
            this.ingredients.addAll(new ArrayList<Ingredient>((Collection<Ingredient>)ingredientsInput));
            this.ingredients.removeIf(Ingredient::m_43947_);
            this.ingredientCount = this.ingredients.size();
            this.usableIngredientItemIds = this.getUsableIngredientItemIds();
            this.usableIngredientSize = this.usableIngredientItemIds.length;
            this.bitSet = new BitSet(this.ingredientCount + this.usableIngredientSize + this.ingredientCount + this.ingredientCount * this.usableIngredientSize);
            for (int ingredientIndex = 0; ingredientIndex < this.ingredients.size(); ++ingredientIndex) {
                IntList possibleStacks = this.ingredients.get(ingredientIndex).m_43931_();
                for (int usableIngredientIndex = 0; usableIngredientIndex < this.usableIngredientSize; ++usableIngredientIndex) {
                    if (!possibleStacks.contains(this.usableIngredientItemIds[usableIngredientIndex])) continue;
                    this.bitSet.set(this.method_7420(true, usableIngredientIndex, ingredientIndex));
                }
            }
        }

        public boolean find(int int_1, @Nullable IntList intList_1) {
            boolean boolean_2;
            if (int_1 <= 0) {
                return true;
            }
            int int_2 = 0;
            while (this.method_7423(int_1)) {
                RecipeFinder.this.take(this.usableIngredientItemIds[this.field_7557.getInt(0)], int_1);
                int int_3 = this.field_7557.size() - 1;
                this.method_7421(this.field_7557.getInt(int_3));
                for (int int_4 = 0; int_4 < int_3; ++int_4) {
                    this.method_7414((int_4 & 1) == 0, this.field_7557.get(int_4), this.field_7557.get(int_4 + 1));
                }
                this.field_7557.clear();
                this.bitSet.clear(0, this.ingredientCount + this.usableIngredientSize);
                ++int_2;
            }
            boolean boolean_1 = int_2 == this.ingredientCount;
            boolean bl = boolean_2 = boolean_1 && intList_1 != null;
            if (boolean_2) {
                intList_1.clear();
            }
            this.bitSet.clear(0, this.ingredientCount + this.usableIngredientSize + this.ingredientCount);
            int int_5 = 0;
            ArrayList<Ingredient> list_1 = new ArrayList<Ingredient>((Collection<Ingredient>)this.ingredientsInput);
            for (Ingredient ingredient : list_1) {
                if (boolean_2 && ingredient.m_43947_()) {
                    intList_1.add(0);
                    continue;
                }
                for (int int_7 = 0; int_7 < this.usableIngredientSize; ++int_7) {
                    if (!this.method_7425(false, int_5, int_7)) continue;
                    this.method_7414(true, int_7, int_5);
                    RecipeFinder.this.addItem(this.usableIngredientItemIds[int_7], int_1);
                    if (!boolean_2) continue;
                    intList_1.add(this.usableIngredientItemIds[int_7]);
                }
                ++int_5;
            }
            return boolean_1;
        }

        private int[] getUsableIngredientItemIds() {
            IntAVLTreeSet intCollection_1 = new IntAVLTreeSet();
            for (Ingredient ingredient_1 : this.ingredients) {
                intCollection_1.addAll((IntCollection)ingredient_1.m_43931_());
            }
            IntIterator intIterator_1 = intCollection_1.iterator();
            while (intIterator_1.hasNext()) {
                if (RecipeFinder.this.contains(intIterator_1.nextInt())) continue;
                intIterator_1.remove();
            }
            return intCollection_1.toIntArray();
        }

        private boolean method_7423(int int_1) {
            int usableIngredientSize = this.usableIngredientSize;
            for (int int_3 = 0; int_3 < usableIngredientSize; ++int_3) {
                if (RecipeFinder.this.idToAmountMap.get(this.usableIngredientItemIds[int_3]) < int_1) continue;
                this.method_7413(false, int_3);
                while (!this.field_7557.isEmpty()) {
                    int int_8;
                    int int_4 = this.field_7557.size();
                    boolean boolean_1 = (int_4 & 1) == 1;
                    int int_5 = this.field_7557.getInt(int_4 - 1);
                    if (!boolean_1 && !this.method_7416(int_5)) break;
                    int int_6 = boolean_1 ? this.ingredientCount : usableIngredientSize;
                    for (int_8 = 0; int_8 < int_6; ++int_8) {
                        if (this.method_7426(boolean_1, int_8) || !this.method_7418(boolean_1, int_5, int_8) || !this.method_7425(boolean_1, int_5, int_8)) continue;
                        this.method_7413(boolean_1, int_8);
                        break;
                    }
                    if ((int_8 = this.field_7557.size()) != int_4) continue;
                    this.field_7557.removeInt(int_8 - 1);
                }
                if (this.field_7557.isEmpty()) continue;
                return true;
            }
            return false;
        }

        private boolean method_7416(int int_1) {
            return this.bitSet.get(this.method_7419(int_1));
        }

        private void method_7421(int int_1) {
            this.bitSet.set(this.method_7419(int_1));
        }

        private int method_7419(int int_1) {
            return this.ingredientCount + this.usableIngredientSize + int_1;
        }

        private boolean method_7418(boolean boolean_1, int int_1, int int_2) {
            return this.bitSet.get(this.method_7420(boolean_1, int_1, int_2));
        }

        private boolean method_7425(boolean boolean_1, int int_1, int int_2) {
            return boolean_1 != this.bitSet.get(1 + this.method_7420(boolean_1, int_1, int_2));
        }

        private void method_7414(boolean boolean_1, int int_1, int int_2) {
            this.bitSet.flip(1 + this.method_7420(boolean_1, int_1, int_2));
        }

        private int method_7420(boolean boolean_1, int int_1, int int_2) {
            int int_3 = boolean_1 ? int_1 * this.ingredientCount + int_2 : int_2 * this.ingredientCount + int_1;
            return this.ingredientCount + this.usableIngredientSize + this.ingredientCount + 2 * int_3;
        }

        private void method_7413(boolean boolean_1, int int_1) {
            this.bitSet.set(this.method_7424(boolean_1, int_1));
            this.field_7557.add(int_1);
        }

        private boolean method_7426(boolean boolean_1, int int_1) {
            return this.bitSet.get(this.method_7424(boolean_1, int_1));
        }

        private int method_7424(boolean boolean_1, int int_1) {
            return (boolean_1 ? 0 : this.ingredientCount) + int_1;
        }

        public int countCrafts(int int_1, @Nullable IntList intList_1) {
            int int_2 = 0;
            int int_3 = Math.min(int_1, this.method_7415()) + 1;
            while (true) {
                int int_4;
                if (this.find(int_4 = (int_2 + int_3) / 2, null)) {
                    if (int_3 - int_2 <= 1) {
                        if (int_4 > 0) {
                            this.find(int_4, intList_1);
                        }
                        return int_4;
                    }
                    int_2 = int_4;
                    continue;
                }
                int_3 = int_4;
            }
        }

        private int method_7415() {
            int int_1 = Integer.MAX_VALUE;
            for (Ingredient ingredient_1 : this.ingredients) {
                int int_2 = 0;
                IntListIterator var5 = ingredient_1.m_43931_().iterator();
                while (var5.hasNext()) {
                    int int_3 = var5.next();
                    int_2 = Math.max(int_2, RecipeFinder.this.idToAmountMap.get(int_3));
                }
                if (int_1 <= 0) continue;
                int_1 = Math.min(int_1, int_2);
            }
            return int_1;
        }
    }
}

