/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.drag.component;

import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.shedaniel.rei.api.client.gui.drag.DraggableBoundsProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitor;
import net.minecraft.client.gui.screens.Screen;

public interface DraggableComponentVisitorWidget {
    public static DraggableComponentVisitorWidget from(final Function<DraggingContext<Screen>, Iterable<DraggableComponentVisitorWidget>> providers) {
        return new DraggableComponentVisitorWidget(){

            @Override
            public DraggedAcceptorResult acceptDragged(DraggingContext<Screen> context, DraggableComponent<?> component) {
                return StreamSupport.stream(((Iterable)providers.apply(context)).spliterator(), false).map(visitor -> visitor.acceptDragged(context, component)).filter(result -> result != DraggedAcceptorResult.PASS).findFirst().orElse(DraggedAcceptorResult.PASS);
            }

            @Override
            public Stream<DraggableBoundsProvider> getDraggableAcceptingBounds(DraggingContext<Screen> context, DraggableComponent<?> component) {
                return StreamSupport.stream(((Iterable)providers.apply(context)).spliterator(), false).flatMap(visitor -> visitor.getDraggableAcceptingBounds(context, component));
            }
        };
    }

    default public DraggedAcceptorResult acceptDragged(DraggingContext<Screen> context, DraggableComponent<?> component) {
        return DraggedAcceptorResult.PASS;
    }

    default public Stream<DraggableBoundsProvider> getDraggableAcceptingBounds(DraggingContext<Screen> context, DraggableComponent<?> component) {
        return Stream.empty();
    }

    public static DraggableComponentVisitor<Screen> toVisitor(DraggableComponentVisitorWidget widget) {
        return DraggableComponentVisitorWidget.toVisitor(widget, 0.0);
    }

    public static DraggableComponentVisitor<Screen> toVisitor(final DraggableComponentVisitorWidget widget, final double priority) {
        return new DraggableComponentVisitor<Screen>(){

            @Override
            public DraggedAcceptorResult acceptDragged(DraggingContext<Screen> context, DraggableComponent<?> component) {
                return widget.acceptDragged(context, component);
            }

            @Override
            public <R extends Screen> boolean isHandingScreen(R screen) {
                return true;
            }

            @Override
            public Stream<DraggableBoundsProvider> getDraggableAcceptingBounds(DraggingContext<Screen> context, DraggableComponent<?> component) {
                return widget.getDraggableAcceptingBounds(context, component);
            }

            @Override
            public double getPriority() {
                return priority;
            }
        };
    }
}

