/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.drag.component;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.shedaniel.rei.api.client.gui.drag.DraggableBoundsProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import net.minecraft.client.gui.screens.Screen;

public interface DraggableComponentVisitor<T extends Screen>
extends Comparable<DraggableComponentVisitor<T>> {
    public static <T extends Screen> DraggableComponentVisitor<T> from(final Supplier<? extends Iterable<? extends DraggableComponentVisitor<T>>> visitors) {
        return new DraggableComponentVisitor<T>(){

            @Override
            public <R extends Screen> boolean isHandingScreen(R screen) {
                for (DraggableComponentVisitor visitor : (Iterable)visitors.get()) {
                    if (!visitor.isHandingScreen(screen)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public DraggedAcceptorResult acceptDragged(DraggingContext<T> context, DraggableComponent<?> component) {
                for (DraggableComponentVisitor visitor : (Iterable)visitors.get()) {
                    DraggedAcceptorResult result;
                    if (!visitor.isHandingScreen(context.getScreen()) || (result = Objects.requireNonNull(visitor.acceptDragged(context, component))) == DraggedAcceptorResult.PASS) continue;
                    return result;
                }
                return DraggedAcceptorResult.PASS;
            }

            @Override
            public Stream<DraggableBoundsProvider> getDraggableAcceptingBounds(DraggingContext<T> context, DraggableComponent<?> component) {
                return StreamSupport.stream(((Iterable)visitors.get()).spliterator(), false).filter(visitor -> visitor.isHandingScreen(context.getScreen())).flatMap(visitor -> visitor.getDraggableAcceptingBounds(context, component));
            }
        };
    }

    default public DraggedAcceptorResult acceptDragged(DraggingContext<T> context, DraggableComponent<?> component) {
        return DraggedAcceptorResult.PASS;
    }

    default public Stream<DraggableBoundsProvider> getDraggableAcceptingBounds(DraggingContext<T> context, DraggableComponent<?> component) {
        return Stream.empty();
    }

    public <R extends Screen> boolean isHandingScreen(R var1);

    default public DraggingContext<T> getContext() {
        return DraggingContext.getInstance().cast();
    }

    default public double getPriority() {
        return 0.0;
    }

    @Override
    default public int compareTo(DraggableComponentVisitor<T> o) {
        return Double.compare(this.getPriority(), o.getPriority());
    }
}

