/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.drag.component;

import java.util.function.Function;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProvider;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface DraggableComponentProviderWidget<A> {
    public static <A> DraggableComponentProviderWidget<A> from(Function<DraggingContext<Screen>, Iterable<DraggableComponentProviderWidget<A>>> providers) {
        return (context, mouseX, mouseY) -> {
            for (DraggableComponentProviderWidget provider : (Iterable)providers.apply(context)) {
                DraggableComponent component = provider.getHovered(context, mouseX, mouseY);
                if (component == null) continue;
                return component;
            }
            return null;
        };
    }

    @Nullable
    public DraggableComponent<A> getHovered(DraggingContext<Screen> var1, double var2, double var4);

    public static <A> DraggableComponentProvider<Screen, A> toProvider(DraggableComponentProviderWidget<A> widget) {
        return DraggableComponentProviderWidget.toProvider(widget, 0.0);
    }

    public static <A> DraggableComponentProvider<Screen, A> toProvider(final DraggableComponentProviderWidget<A> widget, final double priority) {
        return new DraggableComponentProvider<Screen, A>(){

            @Override
            @Nullable
            public DraggableComponent<A> getHovered(DraggingContext<Screen> context, double mouseX, double mouseY) {
                return widget.getHovered(context, mouseX, mouseY);
            }

            @Override
            public <R extends Screen> boolean isHandingScreen(R screen) {
                return true;
            }

            @Override
            public double getPriority() {
                return priority;
            }
        };
    }
}

