/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.drag;

import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.shedaniel.rei.api.client.gui.drag.DraggableBoundsProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitorWidget;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.minecraft.client.gui.screens.Screen;

public interface DraggableStackVisitorWidget
extends DraggableComponentVisitorWidget {
    public static DraggableStackVisitorWidget from(final Function<DraggingContext<Screen>, Iterable<DraggableStackVisitorWidget>> providers) {
        return new DraggableStackVisitorWidget(){

            @Override
            public DraggedAcceptorResult acceptDraggedStack(DraggingContext<Screen> context, DraggableStack stack) {
                return StreamSupport.stream(((Iterable)providers.apply(context)).spliterator(), false).map(visitor -> visitor.acceptDraggedStack(context, stack)).filter(result -> result != DraggedAcceptorResult.PASS).findFirst().orElse(DraggedAcceptorResult.PASS);
            }

            @Override
            public Stream<DraggableStackVisitor.BoundsProvider> getDraggableAcceptingBounds(DraggingContext<Screen> context, DraggableStack stack) {
                return StreamSupport.stream(((Iterable)providers.apply(context)).spliterator(), false).flatMap(visitor -> visitor.getDraggableAcceptingBounds(context, stack));
            }
        };
    }

    default public DraggedAcceptorResult acceptDraggedStack(DraggingContext<Screen> context, DraggableStack stack) {
        return DraggedAcceptorResult.PASS;
    }

    @Override
    default public DraggedAcceptorResult acceptDragged(DraggingContext<Screen> context, DraggableComponent<?> component) {
        return component.getIf(new EntryStack[0]).map(comp -> this.acceptDraggedStack(context, DraggableStack.from(comp))).orElse(DraggedAcceptorResult.PASS);
    }

    default public Stream<DraggableStackVisitor.BoundsProvider> getDraggableAcceptingBounds(DraggingContext<Screen> context, DraggableStack stack) {
        return Stream.empty();
    }

    @Override
    default public Stream<DraggableBoundsProvider> getDraggableAcceptingBounds(DraggingContext<Screen> context, DraggableComponent<?> component) {
        return component.getIf(new EntryStack[0]).map(comp -> this.getDraggableAcceptingBounds(context, DraggableStack.from(comp))).orElse(Stream.empty()).map(Function.identity());
    }

    public static DraggableStackVisitor<Screen> toVisitor(DraggableStackVisitorWidget widget) {
        return DraggableStackVisitorWidget.toVisitor(widget, 0.0);
    }

    public static DraggableStackVisitor<Screen> toVisitor(final DraggableStackVisitorWidget widget, final double priority) {
        return new DraggableStackVisitor<Screen>(){

            @Override
            public DraggedAcceptorResult acceptDraggedStack(DraggingContext<Screen> context, DraggableStack stack) {
                return widget.acceptDraggedStack(context, stack);
            }

            @Override
            public <R extends Screen> boolean isHandingScreen(R screen) {
                return true;
            }

            @Override
            public Stream<DraggableStackVisitor.BoundsProvider> getDraggableAcceptingBounds(DraggingContext<Screen> context, DraggableStack stack) {
                return widget.getDraggableAcceptingBounds(context, stack);
            }

            @Override
            public double getPriority() {
                return priority;
            }
        };
    }
}

