/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.drag;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableBoundsProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitor;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface DraggableStackVisitor<T extends Screen>
extends DraggableComponentVisitor<T> {
    public static <T extends Screen> DraggableStackVisitor<T> from(final Supplier<Iterable<DraggableStackVisitor<T>>> visitors) {
        return new DraggableStackVisitor<T>(){

            @Override
            public <R extends Screen> boolean isHandingScreen(R screen) {
                for (DraggableStackVisitor visitor : (Iterable)visitors.get()) {
                    if (!visitor.isHandingScreen(screen)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public DraggedAcceptorResult acceptDraggedStack(DraggingContext<T> context, DraggableStack stack) {
                for (DraggableStackVisitor visitor : (Iterable)visitors.get()) {
                    DraggedAcceptorResult result;
                    if (!visitor.isHandingScreen(context.getScreen()) || (result = Objects.requireNonNull(visitor.acceptDraggedStack(context, stack))) == DraggedAcceptorResult.PASS) continue;
                    return result;
                }
                return DraggedAcceptorResult.PASS;
            }

            @Override
            public Stream<BoundsProvider> getDraggableAcceptingBounds(DraggingContext<T> context, DraggableStack stack) {
                return StreamSupport.stream(((Iterable)visitors.get()).spliterator(), false).filter(visitor -> visitor.isHandingScreen(context.getScreen())).flatMap(visitor -> visitor.getDraggableAcceptingBounds(context, stack));
            }
        };
    }

    default public DraggedAcceptorResult acceptDraggedStack(DraggingContext<T> context, DraggableStack stack) {
        return DraggedAcceptorResult.PASS;
    }

    @Override
    default public DraggedAcceptorResult acceptDragged(DraggingContext<T> context, DraggableComponent<?> component) {
        return component.getIf(new EntryStack[0]).map(comp -> this.acceptDraggedStack(context, DraggableStack.from(comp))).orElse(DraggedAcceptorResult.PASS);
    }

    default public Stream<BoundsProvider> getDraggableAcceptingBounds(DraggingContext<T> context, DraggableStack stack) {
        return Stream.empty();
    }

    @Override
    default public Stream<DraggableBoundsProvider> getDraggableAcceptingBounds(DraggingContext<T> context, DraggableComponent<?> component) {
        return component.getIf(new EntryStack[0]).map(comp -> this.getDraggableAcceptingBounds(context, DraggableStack.from(comp))).orElse(Stream.empty()).map(Function.identity());
    }

    @Override
    public <R extends Screen> boolean isHandingScreen(R var1);

    @Override
    default public DraggingContext<T> getContext() {
        return DraggingContext.getInstance().cast();
    }

    @Override
    default public double getPriority() {
        return 0.0;
    }

    @Override
    default public int compareTo(DraggableStackVisitor<T> o) {
        return Double.compare(this.getPriority(), o.getPriority());
    }

    @FunctionalInterface
    public static interface BoundsProvider
    extends DraggableBoundsProvider {
        public static VoxelShape fromRectangle(Rectangle bounds) {
            return DraggableBoundsProvider.fromRectangle(bounds);
        }

        public static BoundsProvider ofRectangle(Rectangle bounds) {
            return DraggableBoundsProvider.ofRectangle(bounds)::bounds;
        }

        public static BoundsProvider ofRectangles(Iterable<Rectangle> bounds) {
            return DraggableBoundsProvider.ofRectangles(bounds)::bounds;
        }

        public static BoundsProvider ofShape(VoxelShape shape) {
            return DraggableBoundsProvider.ofShape(shape)::bounds;
        }

        public static BoundsProvider ofShapes(Iterable<VoxelShape> shapes) {
            return DraggableBoundsProvider.ofShapes(shapes)::bounds;
        }

        public static BoundsProvider empty() {
            return Shapes::m_83040_;
        }

        public static BoundsProvider concat(Iterable<BoundsProvider> providers) {
            return DraggableBoundsProvider.concat((List)providers)::bounds;
        }

        @Override
        public VoxelShape bounds();
    }

    @FunctionalInterface
    public static interface Acceptor {
        public void accept(DraggableStack var1);
    }
}

