/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.wireless.blocks;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.keys.NetworkId;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.xnet.client.ControllerChannelClientInfo;
import mcjty.xnet.compat.XNetTOPDriver;
import mcjty.xnet.logic.LogicTools;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.controller.blocks.TileEntityController;
import mcjty.xnet.modules.router.blocks.TileEntityRouter;
import mcjty.xnet.modules.wireless.WirelessRouterModule;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.WirelessChannelKey;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import mcjty.xnet.multiblock.XNetWirelessChannels;
import mcjty.xnet.setup.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;

public final class TileEntityWirelessRouter
extends TickingTileEntity {
    public static final int TIER_INVALID = -1;
    public static final int TIER_1 = 0;
    public static final int TIER_2 = 1;
    public static final int TIER_INF = 2;
    private boolean error = false;
    private int counter = 10;
    @GuiValue(name="public")
    private boolean publicAccess = false;
    private int globalChannelVersion = -1;
    @Cap(type=CapType.ENERGY)
    private final LazyOptional<GenericEnergyStorage> energyHandler = LazyOptional.of(() -> new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)Config.wirelessRouterMaxRF.get()).intValue(), (long)((Integer)Config.wirelessRouterRfPerTick.get()).intValue()));
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Wireless Router").containerSupplier(DefaultContainerProvider.empty(WirelessRouterModule.CONTAINER_WIRELESS_ROUTER, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));

    public TileEntityWirelessRouter(BlockPos pos, BlockState state) {
        super((BlockEntityType)WirelessRouterModule.TYPE_WIRELESS_ROUTER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().topDriver((TOPDriver)XNetTOPDriver.DRIVER).tileEntitySupplier(TileEntityWirelessRouter::new).manualEntry(ManualHelper.create((String)"xnet:simple/wireless/wireless_router")).info(new InfoLine[]{TooltipBuilder.key((String)"message.xnet.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
                super.m_7926_(builder);
                builder.m_61104_(new Property[]{TileEntityController.ERROR});
            }
        };
    }

    public boolean isPublicAccess() {
        return this.publicAccess;
    }

    public void setPublicAccess(boolean publicAccess) {
        this.publicAccess = publicAccess;
        this.m_6596_();
    }

    public void tickServer() {
        NetworkId networkId;
        --this.counter;
        if (this.counter > 0) {
            return;
        }
        this.counter = 10;
        int version = XNetWirelessChannels.get(this.f_58857_).getGlobalChannelVersion();
        if (this.globalChannelVersion != version) {
            this.globalChannelVersion = version;
            NetworkId networkId2 = this.findRoutingNetwork();
            if (networkId2 != null) {
                WorldBlob worldBlob = XNetBlobData.get(this.f_58857_).getWorldBlob(this.f_58857_);
                worldBlob.markNetworkDirty(networkId2);
            }
        }
        boolean err = false;
        int range = this.getAntennaRange();
        if (range < 0) {
            err = true;
        }
        if (!err && (networkId = this.findRoutingNetwork()) != null) {
            LogicTools.consumers(this.f_58857_, networkId).forEach(consumerPos -> LogicTools.routers(this.f_58857_, consumerPos).forEach(r -> this.publishChannels((TileEntityRouter)((Object)((Object)r)), networkId)));
        }
        this.setError(err);
    }

    private int getAntennaTier() {
        if (this.f_58857_.m_8055_(this.f_58858_.m_7494_()).m_60734_() != WirelessRouterModule.ANTENNA_BASE.get()) {
            return -1;
        }
        Block aboveAntenna = this.f_58857_.m_8055_(this.f_58858_.m_6630_(2)).m_60734_();
        if (aboveAntenna == WirelessRouterModule.ANTENNA_DISH.get()) {
            return 2;
        }
        if (aboveAntenna != WirelessRouterModule.ANTENNA.get()) {
            return -1;
        }
        if (this.f_58857_.m_8055_(this.f_58858_.m_6630_(3)).m_60734_() == WirelessRouterModule.ANTENNA.get()) {
            return 1;
        }
        return 0;
    }

    private int getAntennaRange() {
        int tier = this.getAntennaTier();
        return switch (tier) {
            case -1 -> -1;
            case 0 -> (Integer)Config.antennaTier1Range.get();
            case 1 -> (Integer)Config.antennaTier2Range.get();
            case 2 -> Integer.MAX_VALUE;
            default -> -1;
        };
    }

    private boolean inRange(TileEntityWirelessRouter otherRouter) {
        int thisRange = this.getAntennaRange();
        int otherRange = otherRouter.getAntennaRange();
        if (thisRange >= Integer.MAX_VALUE && otherRange >= Integer.MAX_VALUE) {
            return true;
        }
        if (thisRange <= 0 || otherRange <= 0) {
            return false;
        }
        if (!this.f_58857_.m_46472_().equals((Object)otherRouter.f_58857_.m_46472_())) {
            return false;
        }
        double maxSqdist = Math.min(thisRange, otherRange);
        maxSqdist *= maxSqdist;
        double sqdist = this.f_58858_.m_123331_((Vec3i)otherRouter.f_58858_);
        return sqdist <= maxSqdist;
    }

    private boolean inRange(XNetWirelessChannels.WirelessRouterInfo wirelessRouter) {
        ServerLevel otherWorld = LevelTools.getLevel((Level)this.f_58857_, (ResourceKey)wirelessRouter.getCoordinate().m_122640_());
        if (otherWorld == null) {
            return false;
        }
        return LogicTools.consumers((Level)otherWorld, wirelessRouter.getNetworkId()).filter(arg_0 -> TileEntityWirelessRouter.lambda$inRange$4((Level)otherWorld, arg_0)).anyMatch(arg_0 -> this.lambda$inRange$5((Level)otherWorld, arg_0));
    }

    public void findRemoteChannelInfo(List<ControllerChannelClientInfo> list) {
        NetworkId network = this.findRoutingNetwork();
        if (network == null) {
            return;
        }
        XNetWirelessChannels wirelessData = XNetWirelessChannels.get(this.f_58857_);
        wirelessData.findChannels(this.getOwnerUUID()).forEach(channel -> channel.getRouters().values().stream().filter(routerInfo -> this.isDifferentRouter(network, (XNetWirelessChannels.WirelessRouterInfo)routerInfo)).filter(this::inRange).forEach(routerInfo -> {
            ServerLevel otherWorld = LevelTools.getLevel((Level)this.f_58857_, (ResourceKey)routerInfo.getCoordinate().m_122640_());
            LogicTools.consumers((Level)otherWorld, routerInfo.getNetworkId()).filter(arg_0 -> ((Level)otherWorld).m_46805_(arg_0)).forEach(arg_0 -> TileEntityWirelessRouter.lambda$findRemoteChannelInfo$8((Level)otherWorld, list, arg_0));
        }));
    }

    private boolean isDifferentRouter(NetworkId thisNetwork, XNetWirelessChannels.WirelessRouterInfo routerInfo) {
        return !routerInfo.getCoordinate().m_122640_().equals((Object)this.f_58857_.m_46472_()) || !thisNetwork.equals((Object)routerInfo.getNetworkId());
    }

    private void publishChannels(TileEntityRouter router, NetworkId networkId) {
        int tier = this.getAntennaTier();
        UUID ownerUUID = this.publicAccess ? null : this.getOwnerUUID();
        XNetWirelessChannels wirelessData = XNetWirelessChannels.get(this.f_58857_);
        this.energyHandler.ifPresent(h -> router.publishedChannelStream().forEach(pair -> {
            String name = (String)pair.getKey();
            IChannelType channelType = (IChannelType)pair.getValue();
            long energyStored = h.getEnergy();
            if ((long)((Integer)Config.wirelessRouterRfPerChannel[tier].get()).intValue() <= energyStored) {
                h.consumeEnergy((long)((Integer)Config.wirelessRouterRfPerChannel[tier].get()).intValue());
                wirelessData.transmitChannel(name, channelType, ownerUUID, (ResourceKey<Level>)this.f_58857_.m_46472_(), this.f_58858_, networkId);
            }
        }));
    }

    public void addWirelessConnectors(Map<SidedConsumer, IConnectorSettings> connectors, String channelName, IChannelType type, @Nullable UUID owner, @Nonnull Map<WirelessChannelKey, Integer> wirelessVersions) {
        WirelessChannelKey key = new WirelessChannelKey(channelName, type, owner);
        XNetWirelessChannels.WirelessChannelInfo info = XNetWirelessChannels.get(this.f_58857_).findChannel(key);
        if (info != null) {
            info.getRouters().keySet().stream().filter(routerPos -> !routerPos.m_122640_().equals((Object)this.f_58857_.m_46472_()) || !routerPos.m_122646_().equals((Object)this.f_58858_)).filter(routerPos -> LevelTools.isLoaded((Level)LevelTools.getLevel((Level)this.f_58857_, (ResourceKey)routerPos.m_122640_()), (BlockPos)routerPos.m_122646_())).forEach(routerPos -> {
                NetworkId routingNetwork;
                TileEntityWirelessRouter otherRouter;
                ServerLevel otherWorld = LevelTools.getLevel((Level)this.f_58857_, (ResourceKey)routerPos.m_122640_());
                BlockEntity otherTE = otherWorld.m_7702_(routerPos.m_122646_());
                if (otherTE instanceof TileEntityWirelessRouter && this.inRange(otherRouter = (TileEntityWirelessRouter)otherTE) && !otherRouter.inError() && (routingNetwork = otherRouter.findRoutingNetwork()) != null) {
                    LogicTools.consumers(this.f_58857_, routingNetwork).forEach(consumerPos -> LogicTools.routers((Level)otherWorld, consumerPos).forEach(router -> {
                        if (router.addConnectorsFromConnectedNetworks(connectors, channelName, type)) {
                            wirelessVersions.put(key, info.getVersion());
                        }
                    }));
                }
            });
        }
    }

    private void setError(boolean err) {
        if (this.error != err) {
            this.error = err;
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (this.error) {
                if (!((Boolean)state.m_61143_((Property)TileEntityController.ERROR)).booleanValue()) {
                    this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(true)), 3);
                }
            } else if (((Boolean)state.m_61143_((Property)TileEntityController.ERROR)).booleanValue()) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(false)), 3);
            }
            this.markDirtyQuick();
        }
    }

    public boolean inError() {
        return this.error;
    }

    @Nullable
    public NetworkId findRoutingNetwork() {
        WorldBlob worldBlob = XNetBlobData.get(this.f_58857_).getWorldBlob(this.f_58857_);
        return LogicTools.routingConnectors(this.f_58857_, this.m_58899_()).findFirst().map(worldBlob::getNetworkAt).orElse(null);
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        tagCompound.m_128379_("error", this.error);
        super.m_183515_(tagCompound);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.error = tagCompound.m_128471_("error");
    }

    public void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128379_("publicAcc", this.publicAccess);
    }

    public void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.publicAccess = info.m_128471_("publicAcc");
    }

    public void onReplaced(Level world, BlockPos pos, BlockState state, BlockState newstate) {
        if (state.m_60734_() == newstate.m_60734_()) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            XNetBlobData blobData = XNetBlobData.get(this.f_58857_);
            WorldBlob worldBlob = blobData.getWorldBlob(this.f_58857_);
            worldBlob.removeCableSegment(pos);
            blobData.save();
        }
    }

    public void onBlockPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        if (!world.f_46443_) {
            XNetBlobData blobData = XNetBlobData.get(world);
            WorldBlob worldBlob = blobData.getWorldBlob(world);
            NetworkId networkId = worldBlob.newNetwork();
            worldBlob.createNetworkProvider(pos, new ColorId(CableColor.ROUTING.ordinal() + 1), networkId);
            blobData.save();
        }
    }

    public BlockState getActualState(BlockState state) {
        return (BlockState)state.m_61124_((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(this.inError()));
    }

    private static /* synthetic */ void lambda$findRemoteChannelInfo$8(Level otherWorld, List list, BlockPos consumerPos) {
        LogicTools.routers(otherWorld, consumerPos).forEach(router -> router.findLocalChannelInfo(list, true, true));
    }

    private /* synthetic */ boolean lambda$inRange$5(Level otherWorld, BlockPos consumerPos) {
        return LogicTools.wirelessRouters(otherWorld, consumerPos).anyMatch(this::inRange);
    }

    private static /* synthetic */ boolean lambda$inRange$4(Level otherWorld, BlockPos consumerPos) {
        return LevelTools.isLoaded((Level)otherWorld, (BlockPos)consumerPos);
    }
}

