/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.fluids;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.DefaultChannelSettings;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.apiimpl.EnumStringTranslators;
import mcjty.xnet.apiimpl.fluids.FluidConnectorSettings;
import mcjty.xnet.setup.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;

public class FluidChannelSettings
extends DefaultChannelSettings
implements IChannelSettings {
    public static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");
    public static final String TAG_MODE = "mode";
    private ChannelMode channelMode = ChannelMode.DISTRIBUTE;
    private int delay = 0;
    private int roundRobinOffset = 0;
    private Map<SidedConsumer, FluidConnectorSettings> fluidExtractors = null;
    private List<Pair<SidedConsumer, FluidConnectorSettings>> fluidConsumers = null;

    public ChannelMode getChannelMode() {
        return this.channelMode;
    }

    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        object.add(TAG_MODE, (JsonElement)new JsonPrimitive(this.channelMode.name()));
        return object;
    }

    public void readFromJson(JsonObject data) {
        this.channelMode = EnumStringTranslators.getFluidChannelMode(data.get(TAG_MODE).getAsString());
    }

    public void readFromNBT(CompoundTag tag) {
        this.channelMode = ChannelMode.values()[tag.m_128445_(TAG_MODE)];
        this.delay = tag.m_128451_("delay");
        this.roundRobinOffset = tag.m_128451_("offset");
    }

    public void writeToNBT(CompoundTag tag) {
        tag.m_128344_(TAG_MODE, (byte)this.channelMode.ordinal());
        tag.m_128405_("delay", this.delay);
        tag.m_128405_("offset", this.roundRobinOffset);
    }

    public void tick(int channel, IControllerContext context) {
        --this.delay;
        if (this.delay <= 0) {
            this.delay = 1200;
        }
        if (this.delay % 10 != 0) {
            return;
        }
        int d = this.delay / 10;
        this.updateCache(channel, context);
        Level world = context.getControllerWorld();
        block0: for (Map.Entry<SidedConsumer, FluidConnectorSettings> entry : this.fluidExtractors.entrySet()) {
            FluidStack stack;
            BlockEntity te;
            IFluidHandler handler;
            Direction side;
            BlockPos pos;
            BlockPos extractorPos;
            FluidConnectorSettings settings = entry.getValue();
            if (d % settings.getSpeed() != 0 || (extractorPos = context.findConsumerPosition(entry.getKey().consumerId())) == null || !LevelTools.isLoaded((Level)world, (BlockPos)(pos = extractorPos.m_142300_(side = entry.getKey().side()))) || (handler = (IFluidHandler)FluidChannelSettings.getFluidHandlerAt(te = world.m_7702_(pos), settings.getFacing()).map(h -> h).orElse(null)) == null || this.checkRedstone(world, settings, extractorPos) || !context.matchColor(settings.getColorsMask())) continue;
            FluidStack extractMatcher = settings.getMatcher();
            int toextract = settings.getRate();
            Integer count = settings.getMinmax();
            if (count != null) {
                int amount = this.countFluid(handler, extractMatcher);
                int canextract = amount - count;
                if (canextract <= 0) continue;
                toextract = Math.min(toextract, canextract);
            }
            ArrayList<Pair<SidedConsumer, FluidConnectorSettings>> inserted = new ArrayList<Pair<SidedConsumer, FluidConnectorSettings>>();
            while (!(stack = this.fetchFluid(handler, true, extractMatcher, toextract)).isEmpty()) {
                toextract = stack.getAmount();
                inserted.clear();
                int remaining = this.insertFluidSimulate(inserted, context, stack);
                if (inserted.isEmpty() || (toextract -= remaining) <= 0) continue block0;
                if (remaining > 0) continue;
                if (!context.checkAndConsumeRF(((Integer)Config.controllerOperationRFT.get()).intValue())) continue block0;
                stack = this.fetchFluid(handler, false, extractMatcher, toextract);
                if (stack.isEmpty()) {
                    throw new NullPointerException(handler.getClass().getName() + " misbehaved! handler.drain(" + toextract + ", true) returned null, even though handler.drain(" + toextract + ", false) did not");
                }
                this.insertFluidReal(context, inserted, stack);
                continue block0;
            }
        }
    }

    public void cleanCache() {
        this.fluidExtractors = null;
        this.fluidConsumers = null;
    }

    @Nonnull
    private FluidStack fetchFluid(IFluidHandler handler, boolean simulate, @Nullable FluidStack matcher, int rate) {
        IFluidHandler.FluidAction action;
        IFluidHandler.FluidAction fluidAction = action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
        if (matcher == null) {
            return handler.drain(rate, action);
        }
        matcher = matcher.copy();
        matcher.setAmount(rate);
        return handler.drain(matcher, action);
    }

    private int insertFluidSimulate(@Nonnull List<Pair<SidedConsumer, FluidConnectorSettings>> inserted, @Nonnull IControllerContext context, @Nonnull FluidStack stack) {
        Level world = context.getControllerWorld();
        if (this.channelMode == ChannelMode.PRIORITY) {
            this.roundRobinOffset = 0;
        }
        int amount = stack.getAmount();
        for (int j = 0; j < this.fluidConsumers.size(); ++j) {
            Direction side;
            BlockPos pos;
            BlockEntity te;
            IFluidHandler handler;
            BlockPos consumerPos;
            int i = (j + this.roundRobinOffset) % this.fluidConsumers.size();
            Pair<SidedConsumer, FluidConnectorSettings> entry = this.fluidConsumers.get(i);
            FluidConnectorSettings settings = (FluidConnectorSettings)((Object)entry.getValue());
            if (settings.getMatcher() != null && !settings.getMatcher().equals((Object)stack) || (consumerPos = context.findConsumerPosition(((SidedConsumer)entry.getKey()).consumerId())) == null || !LevelTools.isLoaded((Level)world, (BlockPos)consumerPos) || this.checkRedstone(world, settings, consumerPos) || !context.matchColor(settings.getColorsMask()) || (handler = (IFluidHandler)FluidChannelSettings.getFluidHandlerAt(te = world.m_7702_(pos = consumerPos.m_142300_(side = ((SidedConsumer)entry.getKey()).side())), settings.getFacing()).map(h -> h).orElse(null)) == null) continue;
            int toinsert = Math.min(settings.getRate(), amount);
            Integer count = settings.getMinmax();
            if (count != null) {
                int a = this.countFluid(handler, settings.getMatcher());
                int caninsert = count - a;
                if (caninsert <= 0) continue;
                toinsert = Math.min(toinsert, caninsert);
            }
            FluidStack copy = stack.copy();
            copy.setAmount(toinsert);
            int filled = handler.fill(copy, IFluidHandler.FluidAction.SIMULATE);
            if (filled <= 0) continue;
            inserted.add(entry);
            if ((amount -= filled) > 0) continue;
            return 0;
        }
        return amount;
    }

    private int countFluid(IFluidHandler handler, @Nullable FluidStack matcher) {
        int cnt = 0;
        for (int i = 0; i < handler.getTanks(); ++i) {
            if (handler.getFluidInTank(i).isEmpty() || matcher != null && !matcher.equals((Object)handler.getFluidInTank(i))) continue;
            cnt += handler.getFluidInTank(i).getAmount();
        }
        return cnt;
    }

    private void insertFluidReal(@Nonnull IControllerContext context, @Nonnull List<Pair<SidedConsumer, FluidConnectorSettings>> inserted, @Nonnull FluidStack stack) {
        int amount = stack.getAmount();
        for (Pair<SidedConsumer, FluidConnectorSettings> pair : inserted) {
            BlockPos consumerPosition = context.findConsumerPosition(((SidedConsumer)pair.getKey()).consumerId());
            Direction side = ((SidedConsumer)pair.getKey()).side();
            FluidConnectorSettings settings = (FluidConnectorSettings)((Object)pair.getValue());
            BlockPos pos = consumerPosition.m_142300_(side);
            BlockEntity te = context.getControllerWorld().m_7702_(pos);
            IFluidHandler handler = FluidChannelSettings.getFluidHandlerAt(te, settings.getFacing()).map(h -> h).orElse(null);
            int toinsert = Math.min(settings.getRate(), amount);
            Integer count = settings.getMinmax();
            if (count != null) {
                int a = this.countFluid(handler, settings.getMatcher());
                int caninsert = count - a;
                if (caninsert <= 0) continue;
                toinsert = Math.min(toinsert, caninsert);
            }
            FluidStack copy = stack.copy();
            copy.setAmount(toinsert);
            int filled = handler.fill(copy, IFluidHandler.FluidAction.EXECUTE);
            if (filled <= 0) continue;
            this.roundRobinOffset = (this.roundRobinOffset + 1) % this.fluidConsumers.size();
            if ((amount -= filled) > 0) continue;
            return;
        }
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.fluidExtractors == null) {
            FluidConnectorSettings con;
            this.fluidExtractors = new HashMap<SidedConsumer, FluidConnectorSettings>();
            this.fluidConsumers = new ArrayList<Pair<SidedConsumer, FluidConnectorSettings>>();
            Map connectors = context.getConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                con = (FluidConnectorSettings)((Object)entry.getValue());
                if (con.getFluidMode() == FluidConnectorSettings.FluidMode.EXT) {
                    this.fluidExtractors.put((SidedConsumer)entry.getKey(), con);
                    continue;
                }
                this.fluidConsumers.add((Pair<SidedConsumer, FluidConnectorSettings>)Pair.of((Object)((SidedConsumer)entry.getKey()), (Object)((Object)con)));
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                con = (FluidConnectorSettings)((Object)entry.getValue());
                if (con.getFluidMode() != FluidConnectorSettings.FluidMode.INS) continue;
                this.fluidConsumers.add((Pair<SidedConsumer, FluidConnectorSettings>)Pair.of((Object)((SidedConsumer)entry.getKey()), (Object)((Object)con)));
            }
            this.fluidConsumers.sort((o1, o2) -> ((FluidConnectorSettings)((Object)((Object)o2.getRight()))).getPriority().compareTo(((FluidConnectorSettings)((Object)((Object)o1.getRight()))).getPriority()));
        }
    }

    public boolean isEnabled(String tag) {
        return true;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(iconGuiElements, 22, 80, 11, 10);
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public void createGui(IEditorGui gui) {
        gui.nl().choices(TAG_MODE, "Fluid distribution mode", (Enum)this.channelMode, (Enum[])ChannelMode.values());
    }

    public void update(Map<String, Object> data) {
        this.channelMode = ChannelMode.valueOf(((String)data.get(TAG_MODE)).toUpperCase());
    }

    public int getColors() {
        return 0;
    }

    @Nonnull
    public static LazyOptional<IFluidHandler> getFluidHandlerAt(@Nullable BlockEntity te, Direction intSide) {
        if (te != null) {
            return te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, intSide);
        }
        return LazyOptional.empty();
    }

    public static enum ChannelMode {
        PRIORITY,
        DISTRIBUTE;

    }
}

