/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.util;

import com.hidoni.customizableelytra.util.CustomizationHandler;
import com.hidoni.customizableelytra.util.ElytraCustomizationData;
import com.hidoni.customizableelytra.util.ElytraCustomizationUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class SplitCustomizationHandler
extends CustomizationHandler {
    private final ElytraCustomizationData leftWing;
    private final ElytraCustomizationData rightWing;

    public SplitCustomizationHandler(ItemStack itemIn) {
        super(itemIn.m_41784_().m_128471_("HideCapePattern"), itemIn.m_41784_().m_128451_("WingLightLevel"));
        CompoundTag wingTag = itemIn.m_41737_("WingInfo");
        this.leftWing = ElytraCustomizationUtil.getData(wingTag.m_128469_("left"));
        this.rightWing = ElytraCustomizationUtil.getData(wingTag.m_128469_("right"));
    }

    @Override
    public int getColor(int index) {
        return index == 0 ? this.leftWing.handler.getColor(index) : this.rightWing.handler.getColor(index);
    }

    @Override
    public boolean isWingCapeHidden(int index) {
        return super.isWingCapeHidden(index) || (index == 0 ? this.leftWing.handler.isWingCapeHidden(index) : this.rightWing.handler.isWingCapeHidden(index));
    }

    @Override
    public int modifyWingLight(int lightLevel, int index) {
        int baseWingLight = super.modifyWingLight(lightLevel, index);
        if (baseWingLight != lightLevel) {
            return baseWingLight;
        }
        return index == 0 ? this.leftWing.handler.modifyWingLight(lightLevel, index) : this.rightWing.handler.modifyWingLight(lightLevel, index);
    }

    public <T extends LivingEntity, M extends AgeableListModel<T>> void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, List<M> renderModels, ResourceLocation leftWingTexture, ResourceLocation rightWingTexture, boolean hasGlint) {
        this.leftWing.handler.render(matrixStackIn, bufferIn, this.modifyWingLight(packedLightIn, 0), entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, (AgeableListModel)renderModels.get(0), leftWingTexture, hasGlint);
        this.rightWing.handler.render(matrixStackIn, bufferIn, this.modifyWingLight(packedLightIn, 1), entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, (AgeableListModel)renderModels.get(1), rightWingTexture, hasGlint);
    }
}

