/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.integration.curios;

import com.hidoni.customizableelytra.integration.curios.CustomizableElytraCurio;
import com.hidoni.customizableelytra.items.CustomizableElytraItem;
import com.hidoni.customizableelytra.util.ElytraInventoryUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.caelus.api.CaelusApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypePreset;

public class CuriosIntegration {
    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ModEventBusHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventBusHandler());
    }

    public static class ModEventBusHandler {
        @SubscribeEvent
        public void imcEnqueueHandler(InterModEnqueueEvent event) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
        }
    }

    public static class ForgeEventBusHandler {
        @SubscribeEvent
        public void playerTickHandler(TickEvent.PlayerTickEvent event) {
            Player player = event.player;
            AttributeInstance attributeInstance = player.m_21051_(CaelusApi.getInstance().getFlightAttribute());
            if (attributeInstance != null) {
                attributeInstance.m_22130_(CustomizableElytraCurio.ELYTRA_FLIGHT_MODIFIER);
                ItemStack curioElytra = ElytraInventoryUtil.getCurioElytra((LivingEntity)player);
                if (!attributeInstance.m_22109_(CustomizableElytraCurio.ELYTRA_FLIGHT_MODIFIER) && curioElytra != ItemStack.f_41583_ && CustomizableElytraItem.m_41140_((ItemStack)curioElytra)) {
                    attributeInstance.m_22118_(CustomizableElytraCurio.ELYTRA_FLIGHT_MODIFIER);
                }
            }
        }

        @SubscribeEvent
        public void attachCapabilitiesHandler(AttachCapabilitiesEvent<ItemStack> event) {
            ItemStack stack = (ItemStack)event.getObject();
            if (stack.m_41720_() instanceof CustomizableElytraItem) {
                final LazyOptional curio = LazyOptional.of(() -> new CustomizableElytraCurio(stack));
                event.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){

                    @Nonnull
                    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                        return CuriosCapability.ITEM.orEmpty(cap, curio);
                    }
                });
                event.addListener(() -> ((LazyOptional)curio).invalidate());
            }
        }
    }
}

