/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.crafting;

import com.hidoni.customizableelytra.setup.ModItems;
import com.hidoni.customizableelytra.setup.ModRecipes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ElytraWingCombinationRecipe
extends CustomRecipe {
    public ElytraWingCombinationRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        ItemStack leftWing = ItemStack.f_41583_;
        ItemStack rightWing = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack inventoryItem = inv.m_8020_(i);
            if (inventoryItem.m_41619_() || inventoryItem.m_41720_() != ModItems.ELYTRA_WING.get()) continue;
            if (leftWing == ItemStack.f_41583_) {
                leftWing = inventoryItem;
                continue;
            }
            if (rightWing == ItemStack.f_41583_) {
                rightWing = inventoryItem;
                continue;
            }
            return false;
        }
        return !leftWing.m_41619_() && !rightWing.m_41619_();
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack leftWing = ItemStack.f_41583_;
        ItemStack rightWing = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack inventoryItem = inv.m_8020_(i);
            if (inventoryItem.m_41619_() || inventoryItem.m_41720_() != ModItems.ELYTRA_WING.get()) continue;
            if (leftWing == ItemStack.f_41583_) {
                leftWing = inventoryItem;
                continue;
            }
            if (rightWing == ItemStack.f_41583_) {
                rightWing = inventoryItem;
                continue;
            }
            return ItemStack.f_41583_;
        }
        ItemStack customizedElytra = new ItemStack((ItemLike)ModItems.CUSTOMIZABLE_ELYTRA.get());
        CompoundTag leftWingNBT = this.convertWingToNBT(leftWing);
        CompoundTag rightWingNBT = this.convertWingToNBT(rightWing);
        CompoundTag wingInfo = new CompoundTag();
        if (leftWingNBT != null) {
            wingInfo.m_128365_("left", (Tag)leftWingNBT);
        }
        if (rightWingNBT != null) {
            wingInfo.m_128365_("right", (Tag)rightWingNBT);
        }
        customizedElytra.m_41700_("WingInfo", (Tag)wingInfo);
        return customizedElytra;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.ELYTRA_WING_COMBINATION_RECIPE.get();
    }

    public CompoundTag convertWingToNBT(ItemStack wingIn) {
        return wingIn.m_41784_();
    }
}

