/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class DamagedIngredient
extends Ingredient {
    private final Ingredient.Value itemList;
    private final int damageValue;

    public DamagedIngredient(Ingredient.Value list, int damageValue) {
        super(Stream.of(list));
        this.itemList = list;
        this.damageValue = damageValue;
    }

    public boolean test(@Nullable ItemStack testStack) {
        if (testStack == null) {
            return false;
        }
        return super.test(testStack) && testStack.m_41773_() == this.damageValue;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        json.add("itemlist", (JsonElement)this.itemList.m_6544_());
        json.addProperty("damage", (Number)this.damageValue);
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<DamagedIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public DamagedIngredient parse(FriendlyByteBuf buffer) {
            JsonParser parser = new JsonParser();
            JsonElement itemList = parser.parse(buffer.m_130277_());
            int damageValue = buffer.readInt();
            return new DamagedIngredient(Ingredient.m_43919_((JsonObject)itemList.getAsJsonObject()), damageValue);
        }

        public DamagedIngredient parse(JsonObject json) {
            JsonElement itemList = json.get("itemlist");
            int damageValue = json.get("damage").getAsInt();
            return new DamagedIngredient(Ingredient.m_43919_((JsonObject)itemList.getAsJsonObject()), damageValue);
        }

        public void write(FriendlyByteBuf buffer, DamagedIngredient ingredient) {
            buffer.m_130070_(ingredient.itemList.m_6544_().toString());
            buffer.writeInt(ingredient.damageValue);
        }
    }
}

