/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.network;

import com.cyanogen.experienceobelisk.block_entities.XPObeliskEntity;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class UpdateToServer {
    public static BlockPos pos;
    public static int XP;
    public static Request request;
    private long playerXP;
    private long finalXP;

    public UpdateToServer(BlockPos pos, int XP, Request request) {
        UpdateToServer.pos = pos;
        UpdateToServer.XP = XP;
        UpdateToServer.request = request;
    }

    public UpdateToServer(FriendlyByteBuf buffer) {
        pos = buffer.m_130135_();
        XP = buffer.readInt();
        request = (Request)buffer.m_130066_(Request.class);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(pos);
        buffer.writeInt(XP);
        buffer.m_130068_((Enum)request);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            assert (sender != null);
            BlockEntity serverEntity = sender.f_19853_.m_7702_(pos);
            this.playerXP = UpdateToServer.levelsToXP(sender.f_36078_) + Math.round(sender.f_36080_ * (float)sender.m_36323_());
            if (serverEntity instanceof XPObeliskEntity) {
                XPObeliskEntity xpobelisk = (XPObeliskEntity)serverEntity;
                if (request == Request.FILL) {
                    this.finalXP = UpdateToServer.levelsToXP(sender.f_36078_ - XP) + Math.round(sender.f_36080_ * (float)(UpdateToServer.levelsToXP(sender.f_36078_ - XP + 1) - UpdateToServer.levelsToXP(sender.f_36078_ - XP)));
                    if (xpobelisk.getSpace() != 0) {
                        if (this.playerXP - this.finalXP >= (long)xpobelisk.getSpace()) {
                            sender.m_6756_(-xpobelisk.fill(16000000));
                        } else if (sender.f_36078_ >= XP) {
                            xpobelisk.fill((int)(this.playerXP - this.finalXP));
                            sender.m_6749_(-XP);
                        } else if (this.playerXP >= 1L) {
                            sender.m_6756_(-xpobelisk.fill((int)this.playerXP));
                        }
                    }
                } else if (request == Request.DRAIN) {
                    int amount = xpobelisk.getFluidAmount();
                    this.finalXP = UpdateToServer.levelsToXP(sender.f_36078_ + XP) + Math.round(sender.f_36080_ * (float)(UpdateToServer.levelsToXP(sender.f_36078_ + XP + 1) - UpdateToServer.levelsToXP(sender.f_36078_ + XP)));
                    if ((long)amount >= this.finalXP - this.playerXP) {
                        xpobelisk.drain((int)(this.finalXP - this.playerXP));
                        sender.m_6749_(XP);
                    } else if (amount >= 1) {
                        sender.m_6756_(amount);
                        xpobelisk.setFluid(0);
                    }
                } else if (request == Request.FILL_ALL) {
                    if (this.playerXP <= (long)xpobelisk.getSpace()) {
                        xpobelisk.fill((int)this.playerXP);
                        sender.m_8985_(0);
                        sender.m_9174_(0);
                    } else {
                        sender.m_6756_(-xpobelisk.getSpace());
                        xpobelisk.setFluid(16000000);
                    }
                } else if (request == Request.DRAIN_ALL) {
                    sender.m_6756_(xpobelisk.getFluidAmount());
                    xpobelisk.setFluid(0);
                }
                success.set(true);
            }
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }

    public static int levelsToXP(int levels) {
        if (levels <= 16) {
            return (int)(Math.pow(levels, 2.0) + (double)(6 * levels));
        }
        if (levels >= 17 && levels <= 31) {
            return (int)(2.5 * Math.pow(levels, 2.0) - 40.5 * (double)levels + 360.0);
        }
        if (levels >= 32) {
            return (int)(4.5 * Math.pow(levels, 2.0) - 162.5 * (double)levels + 2220.0);
        }
        return 0;
    }

    public static enum Request {
        FILL,
        DRAIN,
        FILL_ALL,
        DRAIN_ALL;

    }
}

