/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.block_entities;

import com.cyanogen.experienceobelisk.block_entities.ModTileEntitiesInit;
import com.cyanogen.experienceobelisk.fluid.ModFluidsInit;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class XPObeliskEntity
extends BlockEntity
implements IAnimatable {
    private final AnimationFactory manager = new AnimationFactory((IAnimatable)this);
    protected boolean redstoneEnabled = false;
    protected double radius = 2.5;
    protected FluidTank tank = this.xpObeliskTank();
    private final LazyOptional<IFluidHandler> handler = LazyOptional.of(() -> this.tank);
    private static final Fluid rawExperience = ((FlowingFluid)ModFluidsInit.RAW_EXPERIENCE.get()).m_5613_();
    public static BlockPos pos;
    public static BlockState state;

    private <E extends BlockEntity> PlayState predicate(AnimationEvent<E> event) {
        AnimationController controller = event.getController();
        controller.transitionLengthTicks = 0.0;
        controller.setAnimation(new AnimationBuilder().addAnimation("xpobelisk.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public XPObeliskEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)ModTileEntitiesInit.XPOBELISK_BE.get(), pPos, pState);
        pos = pPos;
        state = pState;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        level.m_7260_(pos, state, state, 2);
        boolean isRedstonePowered = level.m_46753_(pos);
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof XPObeliskEntity) {
            XPObeliskEntity xpobelisk = (XPObeliskEntity)entity;
            boolean absorb = !xpobelisk.isRedstoneEnabled() || isRedstonePowered;
            double radius = xpobelisk.getRadius();
            AABB area = new AABB((double)pos.m_123341_() - radius, (double)pos.m_123342_() - radius, (double)pos.m_123343_() - radius, (double)pos.m_123341_() + radius, (double)pos.m_123342_() + radius, (double)pos.m_123343_() + radius);
            List list = level.m_45933_(null, area);
            for (Entity e : list) {
                if (!(e instanceof ExperienceOrb)) continue;
                ExperienceOrb orb = (ExperienceOrb)e;
                if (xpobelisk.getSpace() <= 0 || !absorb) continue;
                int value = orb.m_20801_();
                xpobelisk.fill(value);
                e.m_146870_();
            }
        }
    }

    public boolean isRedstoneEnabled() {
        return this.redstoneEnabled;
    }

    public void setRedstoneEnabled(boolean state) {
        this.redstoneEnabled = state;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    private FluidTank xpObeliskTank() {
        return new FluidTank(16000000){

            protected void onContentsChanged() {
                super.onContentsChanged();
                XPObeliskEntity.this.m_6596_();
            }

            public void setFluid(FluidStack stack) {
                this.fluid = stack;
                XPObeliskEntity.this.m_6596_();
            }

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid() == rawExperience;
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return stack.getFluid() == rawExperience;
            }
        };
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tank.readFromNBT(tag);
        this.radius = tag.m_128459_("Radius");
        this.redstoneEnabled = tag.m_128471_("isRedstoneControllable");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.tank.writeToNBT(tag);
        tag.m_128347_("Radius", this.radius);
        tag.m_128379_("isRedstoneControllable", this.redstoneEnabled);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.tank.writeToNBT(tag);
        tag.m_128347_("Radius", this.radius);
        tag.m_128379_("isRedstoneControllable", this.redstoneEnabled);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compoundtag = pkt.m_131708_();
        if (compoundtag != null) {
            this.m_142466_(compoundtag);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public int fill(int amount) {
        this.f_58857_.m_7260_(pos, state, state, 2);
        return this.tank.fill(new FluidStack(rawExperience, amount), IFluidHandler.FluidAction.EXECUTE);
    }

    public void drain(int amount) {
        this.tank.drain(new FluidStack(rawExperience, amount), IFluidHandler.FluidAction.EXECUTE);
        this.f_58857_.m_7260_(pos, state, state, 2);
    }

    public void setFluid(int amount) {
        this.tank.setFluid(new FluidStack(rawExperience, amount));
        this.f_58857_.m_7260_(pos, state, state, 2);
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public int getSpace() {
        return this.tank.getSpace();
    }
}

