/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.angelring.compat.curios;

import dev.denismasterherobrine.angelring.compat.curios.AbstractRingCurio;
import dev.denismasterherobrine.angelring.config.Configuration;
import dev.denismasterherobrine.angelring.register.ItemRegistry;
import dev.denismasterherobrine.angelring.utils.ExperienceUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.InterModComms;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class ClassicAngelRingIntegration {
    private static int ticksDrained;

    public static void sendImc() {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("angelring").build());
    }

    public static ICapabilityProvider initCapabilities() {
        final AbstractRingCurio curio = new AbstractRingCurio(ItemRegistry.ItemRing){
            final ItemStack stack = new ItemStack((ItemLike)ItemRegistry.ItemRing.m_5456_());

            public ItemStack getStack() {
                return this.stack;
            }

            @Override
            protected boolean checkIfAllowedToFly(Player player, ItemStack stack) {
                if ((Integer)Configuration.XPCost.get() == 0) {
                    return true;
                }
                return ExperienceUtils.getPlayerXP(player) >= (Integer)Configuration.XPCost.get();
            }

            @Override
            protected TranslatableComponent getNotAbleToFlyMessage() {
                return new TranslatableComponent("item.angelring.itemring.not_enough_xp");
            }

            @Override
            protected void payForFlight(Player player, ItemStack stack) {
                if (++ticksDrained >= (Integer)Configuration.TicksPerDrain.get()) {
                    ExperienceUtils.addPlayerXP(player, -((Integer)Configuration.XPCost.get()).intValue());
                    ticksDrained = 0;
                }
            }
        };
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
    }

    public static boolean isRingInCuriosSlot(ItemStack angelRing, LivingEntity player) {
        return CuriosApi.getCuriosHelper().findEquippedCurio(angelRing.m_41720_(), player).isPresent();
    }
}

