/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.angelring.compat.curios;

import dev.denismasterherobrine.angelring.register.ItemRegistry;
import java.util.Optional;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurio;

public abstract class AbstractRingCurio
implements ICurio {
    private final Item item;

    public AbstractRingCurio(Item item) {
        this.item = item;
    }

    public boolean canEquipFromUse(SlotContext slotContext) {
        return true;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack) {
        if (newStack.m_41720_().getClass() == this.item.getClass()) {
            return;
        }
        if (newStack.getCapability(CapabilityEnergy.ENERGY).isPresent() && this.item.m_7968_().getCapability(CapabilityEnergy.ENERGY).isPresent() && ((IEnergyStorage)newStack.getCapability(CapabilityEnergy.ENERGY).resolve().get()).getEnergyStored() == ((IEnergyStorage)this.item.m_7968_().getCapability(CapabilityEnergy.ENERGY).resolve().get()).getEnergyStored()) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_7500_() || player.m_5833_()) {
                return;
            }
            this.stopFlying(player);
        }
    }

    private void startFlying(Player player) {
        player.m_150110_().f_35936_ = true;
        player.m_6885_();
    }

    private void stopFlying(Player player) {
        player.m_150110_().f_35935_ = false;
        player.m_150110_().f_35936_ = false;
        player.m_6885_();
    }

    public boolean canEquip(String identifier, LivingEntity entityLivingBase) {
        return !CuriosApi.getCuriosHelper().findFirstCurio(entityLivingBase, ItemRegistry.ItemRing).isPresent();
    }

    public void onEquipFromUse(SlotContext slotContext) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public boolean showAttributesTooltip(String identifier) {
        return true;
    }

    protected abstract boolean checkIfAllowedToFly(Player var1, ItemStack var2);

    protected abstract TranslatableComponent getNotAbleToFlyMessage();

    protected abstract void payForFlight(Player var1, ItemStack var2);

    public void curioTick(SlotContext slotContext) {
        Optional optStack = CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), this.item);
        if (optStack.isEmpty()) {
            return;
        }
        ItemStack stack = ((SlotResult)optStack.get()).stack().getContainerItem();
        if (slotContext.entity() instanceof Player) {
            Player player = (Player)slotContext.entity();
            if (player.m_7500_() || player.m_5833_()) {
                return;
            }
            if (this.checkIfAllowedToFly(player, stack) && !player.m_150110_().f_35936_) {
                this.startFlying(player);
            } else if (!this.checkIfAllowedToFly(player, stack) && player.m_150110_().f_35936_) {
                this.stopFlying(player);
                if (player instanceof ServerPlayer) {
                    ((ServerPlayer)player).m_9146_((Component)this.getNotAbleToFlyMessage(), ChatType.GAME_INFO, player.m_142081_());
                }
            }
            if (player.m_150110_().f_35936_ && player.m_150110_().f_35935_) {
                this.payForFlight(player, stack);
            }
        }
    }
}

