/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.helper;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ModuleEnums {

    public static enum ConnectorMode {
        INS,
        EXT;

        private static final Map<String, ConnectorMode> NAME_MAP;

        public static ConnectorMode byName(String name) {
            return NAME_MAP.get(name.toUpperCase(Locale.ROOT));
        }

        static {
            NAME_MAP = Arrays.stream(ConnectorMode.values()).collect(Collectors.toMap(Enum::name, Function.identity()));
        }
    }

    public static enum ChannelMode {
        PRIORITY,
        DISTRIBUTE;

        private static final Map<String, ChannelMode> NAME_MAP;

        public static ChannelMode byName(String name) {
            return NAME_MAP.get(name.toUpperCase(Locale.ROOT));
        }

        static {
            NAME_MAP = Arrays.stream(ChannelMode.values()).collect(Collectors.toMap(Enum::name, Function.identity()));
        }
    }
}

