/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.gui.BiomeSearchEntry;
import com.chaosthedude.naturescompass.gui.NaturesCompassScreen;
import com.chaosthedude.naturescompass.util.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BiomeSearchList
extends ObjectSelectionList<BiomeSearchEntry> {
    private final NaturesCompassScreen parentScreen;

    public BiomeSearchList(NaturesCompassScreen parentScreen, Minecraft mc, int width, int height, int top, int bottom, int slotHeight) {
        super(mc, width, height, top, bottom, slotHeight);
        this.parentScreen = parentScreen;
        this.refreshList();
    }

    protected int m_5756_() {
        return super.m_5756_() + 20;
    }

    public int m_5759_() {
        return super.m_5759_() + 50;
    }

    protected boolean m_7987_(int slotIndex) {
        return slotIndex >= 0 && slotIndex < this.m_6702_().size() ? ((Object)((Object)((BiomeSearchEntry)((Object)this.m_6702_().get(slotIndex))))).equals(this.m_93511_()) : false;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int k = this.m_5747_();
        int l = this.f_93390_ + 4 - (int)this.m_93517_();
        this.m_93451_(poseStack, k, l, mouseX, mouseY, partialTicks);
    }

    protected void m_93451_(PoseStack poseStack, int par1, int par2, int mouseX, int mouseY, float partialTicks) {
        for (int j = 0; j < this.m_5773_(); ++j) {
            int k = this.m_7610_(j);
            int l = this.getRowBottom(j);
            if (l < this.f_93390_ || k > this.f_93391_) continue;
            int j1 = this.f_93387_ - 4;
            BiomeSearchEntry e = (BiomeSearchEntry)this.m_93500_(j);
            int k1 = this.m_5759_();
            if (this.m_7987_(j)) {
                int insideLeft = this.f_93393_ + this.f_93388_ / 2 - this.m_5759_() / 2 + 2;
                RenderUtils.drawRect(insideLeft - 4, k - 4, insideLeft + this.m_5759_() + 4, k + this.f_93387_, 0x7F000000);
            }
            int j2 = this.m_5747_();
            e.m_6311_(poseStack, j, k, j2, k1, j1, mouseX, mouseY, this.m_5953_(mouseX, mouseY) && Objects.equals(this.m_93412_(mouseX, mouseY), (Object)e), partialTicks);
        }
    }

    private int getRowBottom(int itemIndex) {
        return this.m_7610_(itemIndex) + this.f_93387_;
    }

    public void refreshList() {
        this.m_93516_();
        for (Biome biome : this.parentScreen.sortBiomes()) {
            this.m_7085_((AbstractSelectionList.Entry)new BiomeSearchEntry(this, biome));
        }
        this.selectBiome(null);
    }

    public void selectBiome(BiomeSearchEntry entry) {
        this.m_6987_((AbstractSelectionList.Entry)entry);
        this.parentScreen.selectBiome(entry);
    }

    public boolean hasSelection() {
        return this.m_93511_() != null;
    }

    public NaturesCompassScreen getParentScreen() {
        return this.parentScreen;
    }
}

