/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.network;

import com.mrh0.createaddition.CreateAddition;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.util.ClientMinecraftWrapper;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class RemoveConnectorPacket {
    private BlockPos pos;
    private int node;

    public RemoveConnectorPacket(BlockPos pos, int node) {
        this.pos = pos;
        this.node = node;
    }

    public static void encode(RemoveConnectorPacket packet, FriendlyByteBuf tag) {
        tag.m_130064_(packet.pos);
        tag.writeInt(packet.node);
    }

    public static RemoveConnectorPacket decode(FriendlyByteBuf buf) {
        RemoveConnectorPacket scp = new RemoveConnectorPacket(buf.m_130135_(), buf.readInt());
        return scp;
    }

    public static void handle(RemoveConnectorPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                RemoveConnectorPacket.handleData(pkt);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void handleData(RemoveConnectorPacket pkt) {
        BlockEntity te = ClientMinecraftWrapper.getClientLevel().m_7702_(pkt.pos);
        if (te != null && te instanceof IWireNode) {
            IWireNode wn = (IWireNode)te;
            wn.preformRemoveOfNode(pkt.node);
        }
    }

    public static void send(BlockPos pos, int node, Level level) {
        CreateAddition.Network.send(PacketDistributor.DIMENSION.with(() -> level.m_46472_()), (Object)new RemoveConnectorPacket(pos, node));
    }
}

