/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdill.glowinc.entity.projectile;

import com.github.jdill.glowinc.Registry;
import com.github.jdill.glowinc.blocks.GlowBallBlock;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class GlowBallEntity
extends ThrowableItemProjectile {
    public static final String ID = "glow_ball_entity";
    private SoundEvent soundEvent = SoundEvents.f_12389_;

    public GlowBallEntity(LivingEntity livingEntityIn, Level worldIn) {
        super((EntityType)Registry.GLOW_BALL_ENTITY.get(), livingEntityIn, worldIn);
    }

    public GlowBallEntity(EntityType<GlowBallEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public GlowBallEntity(EntityType<? extends ThrowableItemProjectile> type, double x, double y, double z, Level worldIn) {
        super(type, x, y, z, worldIn);
    }

    @Nonnull
    protected Item m_7881_() {
        return (Item)Registry.GLOW_BALL_ITEM.get();
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity = result.m_82443_();
        if (!this.f_19853_.m_5776_() && entity instanceof LivingEntity) {
            ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200));
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (!this.f_19853_.m_5776_()) {
            BlockPos hitBlockPos = result.m_82425_();
            BlockState hitBlockState = this.f_19853_.m_8055_(hitBlockPos);
            Direction direction = result.m_82434_();
            BlockPos maybeBlockPos = hitBlockPos.m_142300_(direction);
            if (hitBlockState.m_60783_((BlockGetter)this.f_19853_, hitBlockPos, direction)) {
                boolean isWater;
                BlockState maybeBlockState = this.f_19853_.m_8055_(maybeBlockPos);
                FluidState maybeFluidState = this.f_19853_.m_6425_(maybeBlockPos);
                boolean bl = isWater = maybeFluidState.m_76152_() == Fluids.f_76193_;
                if (maybeBlockState.m_60795_() || isWater) {
                    BlockState state = ((Block)Registry.GLOW_BALL_BLOCK.get()).m_49966_();
                    BlockState alteredBlockState = (BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction)).m_61124_((Property)GlowBallBlock.WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
                    this.f_19853_.m_46597_(maybeBlockPos, alteredBlockState);
                    this.soundEvent = SoundEvents.f_12392_;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private ParticleOptions makeParticle() {
        return new ItemParticleOption(ParticleTypes.f_123752_, this.m_7846_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 3) {
            int numParticles = 5;
            for (int i = 0; i < numParticles; ++i) {
                this.f_19853_.m_7106_(this.makeParticle(), this.m_20185_(), this.m_20186_(), this.m_20189_(), ((double)this.f_19796_.nextFloat() - 0.5) * 0.08, ((double)this.f_19796_.nextFloat() - 0.1) * 0.08, ((double)this.f_19796_.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    protected void m_6532_(HitResult p_37260_) {
        super.m_6532_(p_37260_);
        if (!this.f_19853_.m_5776_()) {
            this.f_19853_.m_7605_((Entity)this, (byte)3);
            this.m_5496_(this.soundEvent, 0.8f, 0.8f);
            this.m_146870_();
        }
    }

    public boolean m_20069_() {
        return false;
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

