/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdill.glowinc.blocks;

import com.github.jdill.glowinc.Config;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.LevelTicks;

public class GlowBallBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final String ID = "glow_ball";
    public static final int TICKS_IN_MINUTE = 1200;
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)((Integer)Config.GLOW_BALL_BLOCK_MINUTES.get()));
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE_U = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape SHAPE_D = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_N = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_S = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape SHAPE_E = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_W = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.builder().put((Object)Direction.NORTH, (Object)SHAPE_N).put((Object)Direction.SOUTH, (Object)SHAPE_S).put((Object)Direction.EAST, (Object)SHAPE_E).put((Object)Direction.WEST, (Object)SHAPE_W).put((Object)Direction.UP, (Object)SHAPE_U).put((Object)Direction.DOWN, (Object)SHAPE_D).build());

    public GlowBallBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76301_).m_60966_().m_60918_(SoundType.f_56750_).m_60910_().m_60953_(state -> (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? 15 : 10).m_60977_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState1, boolean flag) {
        super.m_6807_(blockState, level, blockPos, blockState1, flag);
        level.m_186460_(blockPos, (Block)this, 1200);
    }

    public void m_7455_(BlockState blockState, ServerLevel level, BlockPos blockPos, Random random) {
        LevelTicks blockTicks = level.m_183326_();
        if (!blockTicks.m_183582_(blockPos, (Object)this)) {
            level.m_186460_(blockPos, (Block)this, 1200);
        }
    }

    public void m_7458_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, Random random) {
        if (((Boolean)Config.GLOW_BALL_BLOCK_PERSISTENT.get()).booleanValue()) {
            serverLevel.m_186460_(blockPos, (Block)this, 1200);
            return;
        }
        int currentAge = (Integer)blockState.m_61143_((Property)AGE) + 1;
        if (currentAge >= (Integer)Config.GLOW_BALL_BLOCK_MINUTES.get()) {
            serverLevel.m_7471_(blockPos, true);
        } else {
            blockState = (BlockState)blockState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(currentAge));
            serverLevel.m_46597_(blockPos, blockState);
        }
    }

    @Nonnull
    public List<ItemStack> m_7381_(@Nonnull BlockState state, @Nonnull LootContext.Builder builder) {
        return Collections.emptyList();
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_142300_(direction.m_122424_());
        BlockState blockstate = reader.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)reader, blockpos, direction);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] adirection;
        BlockState blockstate = this.m_49966_();
        Level levelreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        FluidState fluidState = levelreader.m_6425_(blockpos);
        for (Direction direction : adirection = context.m_6232_()) {
            Direction direction1 = direction.m_122424_();
            if (!(blockstate = (BlockState)blockstate.m_61124_((Property)FACING, (Comparable)direction1)).m_60710_((LevelReader)levelreader, blockpos)) continue;
            return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor levelAccessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return facing.m_122424_() == stateIn.m_61143_((Property)FACING) && !stateIn.m_60710_((LevelReader)levelAccessor, currentPos) ? Blocks.f_50016_.m_49966_() : stateIn;
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nonnull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, FACING, WATERLOGGED});
    }
}

