/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl;

import com.mrcrayfish.configured.impl.ForgeValue;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeListValue
extends ForgeValue<List<?>> {
    private final Function<List<?>, List<?>> converter;

    public ForgeListValue(ForgeConfigSpec.ConfigValue<List<?>> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
        super(configValue, valueSpec);
        this.converter = this.createConverter(configValue);
    }

    @Nullable
    private Function<List<?>, List<?>> createConverter(ForgeConfigSpec.ConfigValue<List<?>> configValue) {
        List original = (List)configValue.get();
        if (original instanceof ArrayList) {
            return ArrayList::new;
        }
        if (original instanceof LinkedList) {
            return LinkedList::new;
        }
        return null;
    }

    @Override
    public void set(List<?> value) {
        this.valueSpec.correct(value);
        super.set(new ArrayList(value));
    }

    public Function<List<?>, List<?>> getConverter() {
        return this.converter;
    }
}

