/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ChangeEnumScreen;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.EditListScreen;
import com.mrcrayfish.configured.client.screen.EditStringScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.StringUtils;

public class ConfigScreen
extends ListMenuScreen {
    public static final Comparator<ListMenuScreen.Item> SORT_ALPHABETICALLY = (o1, o2) -> {
        if (o1 instanceof FolderItem && o2 instanceof FolderItem) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
        if (!(o1 instanceof FolderItem) && o2 instanceof FolderItem) {
            return 1;
        }
        if (o1 instanceof FolderItem) {
            return -1;
        }
        return o1.getLabel().compareTo(o2.getLabel());
    };
    protected final IConfigEntry folderEntry;
    protected IModConfig config;
    protected Button saveButton;
    protected Button restoreButton;

    private ConfigScreen(Screen parent, Component title, ResourceLocation background, IConfigEntry folderEntry) {
        super(parent, title, background, 24);
        this.folderEntry = folderEntry;
    }

    public ConfigScreen(Screen parent, Component title, IModConfig config, ResourceLocation background) {
        super(parent, title, background, 24);
        this.config = config;
        this.folderEntry = config.getRoot();
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        ArrayList<ListMenuScreen.Item> configEntries = new ArrayList<ListMenuScreen.Item>();
        this.folderEntry.getChildren().forEach(c -> {
            if (c.isLeaf()) {
                IConfigValue<Boolean> entry = c.getValue();
                if (entry == null) {
                    return;
                }
                Object value = entry.get();
                if (value instanceof Boolean) {
                    configEntries.add(new BooleanItem(entry));
                } else if (value instanceof Integer) {
                    configEntries.add(new IntegerItem((IConfigValue<Integer>)entry));
                } else if (value instanceof Double) {
                    configEntries.add(new DoubleItem((IConfigValue<Double>)entry));
                } else if (value instanceof Long) {
                    configEntries.add(new LongItem((IConfigValue<Long>)entry));
                } else if (value instanceof Enum) {
                    configEntries.add(new EnumItem((IConfigValue<Enum<?>>)entry));
                } else if (value instanceof String) {
                    configEntries.add(new StringItem((IConfigValue<String>)entry));
                } else if (value instanceof List) {
                    configEntries.add(new ListItem((IConfigValue<List<?>>)entry));
                } else {
                    Configured.LOGGER.info("Unsupported config value: " + entry.getPath());
                }
            } else {
                configEntries.add(new FolderItem((IConfigEntry)c));
            }
        });
        configEntries.sort(SORT_ALPHABETICALLY);
        entries.addAll(configEntries);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        if (this.folderEntry.isRoot()) {
            this.saveButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_96543_ / 2 - 140, this.f_96544_ - 29, 22, 0, 90, (Component)new TranslatableComponent("configured.gui.save"), button -> {
                if (this.config != null) {
                    this.saveConfig();
                }
                this.f_96541_.m_91152_(this.parent);
            }));
            this.restoreButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_96543_ / 2 - 45, this.f_96544_ - 29, 0, 0, 90, (Component)new TranslatableComponent("configured.gui.reset_all"), button -> {
                if (this.folderEntry.isRoot()) {
                    this.showRestoreScreen();
                }
            }));
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 50, this.f_96544_ - 29, 90, 20, CommonComponents.f_130656_, button -> {
                if (this.isChanged(this.folderEntry)) {
                    this.f_96541_.m_91152_((Screen)new ConfirmationScreen(this, (Component)new TranslatableComponent("configured.gui.unsaved_changes"), result -> {
                        if (!result.booleanValue()) {
                            return true;
                        }
                        this.f_96541_.m_91152_(this.parent);
                        return false;
                    }).setBackground(this.background));
                } else {
                    this.f_96541_.m_91152_(this.parent);
                }
            }));
            this.updateButtons();
        } else {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 75, this.f_96544_ - 29, 150, 20, CommonComponents.f_130660_, button -> this.f_96541_.m_91152_(this.parent)));
        }
    }

    private void saveConfig() {
        if (!this.isChanged(this.folderEntry) || this.config == null) {
            return;
        }
        this.config.saveConfig(this.folderEntry);
    }

    private void showRestoreScreen() {
        ConfirmationScreen confirmScreen = new ConfirmationScreen(this, (Component)new TranslatableComponent("configured.gui.restore_message"), result -> {
            if (!result.booleanValue()) {
                return true;
            }
            this.restoreDefaults(this.folderEntry);
            this.updateButtons();
            return true;
        });
        confirmScreen.setBackground(this.background);
        confirmScreen.setPositiveText((Component)new TranslatableComponent("configured.gui.reset_all").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        confirmScreen.setNegativeText(CommonComponents.f_130656_);
        Minecraft.m_91087_().m_91152_((Screen)confirmScreen);
    }

    private void restoreDefaults(IConfigEntry entry) {
        for (IConfigEntry child : entry.getChildren()) {
            if (child.isLeaf()) {
                IConfigValue<?> value = child.getValue();
                if (value == null) continue;
                value.restore();
                continue;
            }
            this.restoreDefaults(child);
        }
    }

    private void updateButtons() {
        if (this.folderEntry.isRoot()) {
            if (this.saveButton != null) {
                this.saveButton.f_93623_ = this.isChanged(this.folderEntry);
            }
            if (this.restoreButton != null) {
                this.restoreButton.f_93623_ = this.isModified(this.folderEntry);
            }
        }
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        this.m_7333_(poseStack);
        this.list.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.searchTextField.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        ConfigScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)7, (int)0xFFFFFF);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    private static String createLabelFromHolder(IConfigValue<?> holder) {
        if (holder.getTranslationKey() != null && I18n.m_118936_((String)holder.getTranslationKey())) {
            return new TranslatableComponent(holder.getTranslationKey()).getString();
        }
        return ConfigScreen.createLabel(holder.getPath());
    }

    public static String createLabel(String input) {
        int i;
        String valueName = input;
        String[] words = valueName.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        valueName = Strings.join((String[])words, (String)" ");
        words = valueName.split("_");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        return Strings.join((String[])words, (String)" ").replaceAll("\\s++", " ");
    }

    public boolean m_6913_() {
        return this.config == null || this.config.getConfigType() != ModConfig.Type.SERVER;
    }

    public boolean isModified(IConfigEntry entry) {
        if (entry.isLeaf()) {
            IConfigValue<?> value = entry.getValue();
            return value != null && value.isDefault();
        }
        for (IConfigEntry child : entry.getChildren()) {
            if (!this.isChanged(child)) continue;
            return true;
        }
        return false;
    }

    public boolean isChanged(IConfigEntry entry) {
        if (entry.isLeaf()) {
            IConfigValue<?> value = entry.getValue();
            return value != null && value.isChanged();
        }
        for (IConfigEntry child : entry.getChildren()) {
            if (!this.isChanged(child)) continue;
            return true;
        }
        return false;
    }

    public class BooleanItem
    extends ConfigItem<Boolean> {
        private final Button button;

        public BooleanItem(IConfigValue<Boolean> holder) {
            super(holder);
            this.button = new Button(10, 5, 46, 20, CommonComponents.m_130666_((boolean)holder.get()), button -> {
                holder.set((Boolean)holder.get() == false);
                button.m_93666_(CommonComponents.m_130666_((boolean)((Boolean)holder.get())));
                ConfigScreen.this.updateButtons();
            });
            this.eventListeners.add(this.button);
        }

        @Override
        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.f_93620_ = left + width - 69;
            this.button.f_93621_ = top;
            this.button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onResetValue() {
            this.button.m_93666_(CommonComponents.m_130666_((boolean)((Boolean)this.holder.get())));
        }
    }

    public class IntegerItem
    extends NumberItem<Integer> {
        public IntegerItem(IConfigValue<Integer> holder) {
            super(holder, Integer::parseInt);
        }
    }

    public class DoubleItem
    extends NumberItem<Double> {
        public DoubleItem(IConfigValue<Double> holder) {
            super(holder, Double::parseDouble);
        }
    }

    public class LongItem
    extends NumberItem<Long> {
        public LongItem(IConfigValue<Long> holder) {
            super(holder, Long::parseLong);
        }
    }

    public class EnumItem
    extends ConfigItem<Enum<?>> {
        private final Button button;

        public EnumItem(IConfigValue<Enum<?>> holder) {
            super(holder);
            this.button = new Button(10, 5, 46, 20, (Component)new TranslatableComponent("configured.gui.change"), button -> Minecraft.m_91087_().m_91152_((Screen)new ChangeEnumScreen(ConfigScreen.this, this.label, ConfigScreen.this.background, (Enum)holder.get(), e -> {
                holder.set((Enum<?>)e);
                ConfigScreen.this.updateButtons();
            })));
            this.eventListeners.add(this.button);
        }

        @Override
        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.f_93620_ = left + width - 69;
            this.button.f_93621_ = top;
            this.button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public class StringItem
    extends ConfigItem<String> {
        private final Button button;

        public StringItem(IConfigValue<String> holder) {
            super(holder);
            this.button = new Button(10, 5, 46, 20, (Component)new TranslatableComponent("configured.gui.edit"), button -> Minecraft.m_91087_().m_91152_((Screen)new EditStringScreen(ConfigScreen.this, ConfigScreen.this.background, this.label, (String)holder.get(), holder::isValid, s -> {
                holder.set((String)s);
                ConfigScreen.this.updateButtons();
            })));
            this.eventListeners.add(this.button);
        }

        @Override
        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.f_93620_ = left + width - 69;
            this.button.f_93621_ = top;
            this.button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public class ListItem
    extends ConfigItem<List<?>> {
        private final Button button;

        public ListItem(IConfigValue<List<?>> holder) {
            super(holder);
            this.button = new Button(10, 5, 46, 20, (Component)new TranslatableComponent("configured.gui.edit"), button -> Minecraft.m_91087_().m_91152_((Screen)new EditListScreen(ConfigScreen.this, this.label, holder, ConfigScreen.this.background)));
            this.eventListeners.add(this.button);
        }

        @Override
        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.f_93620_ = left + width - 69;
            this.button.f_93621_ = top;
            this.button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public class FolderItem
    extends ListMenuScreen.Item {
        private final Button button;

        public FolderItem(IConfigEntry folderEntry) {
            super((ListMenuScreen)ConfigScreen.this, (Component)new TextComponent(ConfigScreen.createLabel(folderEntry.getEntryName())));
            this.button = new Button(10, 5, 44, 20, (Component)new TextComponent(this.getLabel()).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.WHITE), onPress -> {
                MutableComponent newTitle = ConfigScreen.this.f_96539_.m_6881_().m_130946_(" > " + this.getLabel());
                ConfigScreen.this.f_96541_.m_91152_((Screen)new ConfigScreen((Screen)ConfigScreen.this, (Component)newTitle, ConfigScreen.this.background, folderEntry));
            });
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.button);
        }

        public void m_6311_(PoseStack poseStack, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.button.f_93620_ = left - 1;
            this.button.f_93621_ = top;
            this.button.m_93674_(width);
            this.button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    public abstract class NumberItem<T extends Number>
    extends ConfigItem<T> {
        private final ListMenuScreen.FocusedEditBox textField;

        public NumberItem(IConfigValue<T> holder, Function<String, Number> parser) {
            super(holder);
            this.textField = new ListMenuScreen.FocusedEditBox(ConfigScreen.this, ConfigScreen.this.f_96547_, 0, 0, 44, 18, this.label);
            this.textField.m_94144_(((Number)holder.get()).toString());
            this.textField.m_94151_(s -> {
                try {
                    Number n = (Number)parser.apply((String)s);
                    if (holder.isValid(n)) {
                        this.textField.m_94202_(0xE0E0E0);
                        holder.set(n);
                        ConfigScreen.this.updateButtons();
                    } else {
                        this.textField.m_94202_(0xFF0000);
                    }
                }
                catch (Exception ignored) {
                    this.textField.m_94202_(0xFF0000);
                }
            });
            this.eventListeners.add(this.textField);
        }

        @Override
        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(poseStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.textField.f_93620_ = left + width - 68;
            this.textField.f_93621_ = top + 1;
            this.textField.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onResetValue() {
            this.textField.m_94144_(((Number)this.holder.get()).toString());
        }
    }

    public abstract class ConfigItem<T>
    extends ListMenuScreen.Item {
        protected final IConfigValue<T> holder;
        protected final List<GuiEventListener> eventListeners;
        protected final Button resetButton;

        public ConfigItem(IConfigValue<T> holder) {
            super((ListMenuScreen)ConfigScreen.this, ConfigScreen.createLabelFromHolder(holder));
            this.eventListeners = new ArrayList<GuiEventListener>();
            this.holder = holder;
            if (this.holder.getComment() != null) {
                this.tooltip = this.createToolTip(holder);
            }
            int maxTooltipWidth = Math.max(ConfigScreen.this.f_96543_ / 2 - 43, 170);
            Button.OnTooltip tooltip = ScreenUtil.createButtonTooltip(ConfigScreen.this, (Component)new TranslatableComponent("configured.gui.reset"), maxTooltipWidth);
            this.resetButton = new IconButton(0, 0, 0, 0, onPress -> {
                this.holder.restore();
                this.onResetValue();
            }, tooltip);
            this.eventListeners.add((GuiEventListener)this.resetButton);
        }

        protected void onResetValue() {
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return this.eventListeners;
        }

        public void m_6311_(PoseStack poseStack, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            Minecraft.m_91087_().f_91062_.m_92889_(poseStack, this.getTrimmedLabel(width - 75), (float)left, (float)(top + 6), 0xFFFFFF);
            if (this.m_5953_(mouseX, mouseY) && mouseX < ConfigScreen.this.list.m_5747_() + ConfigScreen.this.list.m_5759_() - 67) {
                ConfigScreen.this.setActiveTooltip(this.tooltip);
            }
            this.resetButton.f_93623_ = !this.holder.isDefault();
            this.resetButton.f_93620_ = left + width - 21;
            this.resetButton.f_93621_ = top;
            this.resetButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }

        private Component getTrimmedLabel(int maxWidth) {
            if (((ConfigScreen)ConfigScreen.this).f_96541_.f_91062_.m_92852_((FormattedText)this.label) > maxWidth) {
                return new TextComponent(((ConfigScreen)ConfigScreen.this).f_96541_.f_91062_.m_92854_((FormattedText)this.label, maxWidth).getString() + "...");
            }
            return this.label;
        }

        private List<FormattedCharSequence> createToolTip(IConfigValue<T> holder) {
            int i;
            Font font = Minecraft.m_91087_().f_91062_;
            List lines = font.m_92865_().m_92414_((FormattedText)new TextComponent(holder.getComment()), 200, Style.f_131099_);
            String name = holder.getPath();
            lines.add(0, new TextComponent(name).m_130940_(ChatFormatting.YELLOW));
            int rangeIndex = -1;
            for (i = 0; i < lines.size(); ++i) {
                String text = ((FormattedText)lines.get(i)).getString();
                if (!text.startsWith("Range: ") && !text.startsWith("Allowed Values: ")) continue;
                rangeIndex = i;
                break;
            }
            if (rangeIndex != -1) {
                for (i = rangeIndex; i < lines.size(); ++i) {
                    lines.set(i, new TextComponent(((FormattedText)lines.get(i)).getString()).m_130940_(ChatFormatting.GRAY));
                }
            }
            return Language.m_128107_().m_128112_(lines);
        }
    }
}

