/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.ChatEvent;
import dev.ftb.mods.ftbranks.FTBRanks;
import dev.ftb.mods.ftbranks.api.FTBRanksAPI;
import dev.ftb.mods.ftbranks.api.RankManager;
import dev.ftb.mods.ftbranks.impl.RankManagerImpl;
import dev.ftb.mods.ftbranks.impl.TextComponentParser;
import dev.ftb.mods.ftbranks.impl.condition.AlwaysActiveCondition;
import dev.ftb.mods.ftbranks.impl.condition.AndCondition;
import dev.ftb.mods.ftbranks.impl.condition.CreativeModeCondition;
import dev.ftb.mods.ftbranks.impl.condition.DimensionCondition;
import dev.ftb.mods.ftbranks.impl.condition.FakePlayerCondition;
import dev.ftb.mods.ftbranks.impl.condition.NotCondition;
import dev.ftb.mods.ftbranks.impl.condition.OPCondition;
import dev.ftb.mods.ftbranks.impl.condition.OrCondition;
import dev.ftb.mods.ftbranks.impl.condition.PlaytimeCondition;
import dev.ftb.mods.ftbranks.impl.condition.RankAddedCondition;
import dev.ftb.mods.ftbranks.impl.condition.SpawnCondition;
import dev.ftb.mods.ftbranks.impl.condition.StatCondition;
import dev.ftb.mods.ftbranks.impl.condition.XorCondition;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.TextFilter;

public class FTBRanksAPIImpl
extends FTBRanksAPI {
    public static RankManagerImpl manager;

    @Override
    public RankManager getManager() {
        return manager;
    }

    public static void serverAboutToStart(MinecraftServer server) {
        manager = new RankManagerImpl(server);
    }

    public static void serverStarted(MinecraftServer server) {
        try {
            manager.load();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void serverStopped(MinecraftServer server) {
        manager = null;
    }

    public static void worldSaved(ServerLevel event) {
        if (manager != null) {
            manager.saveRanksNow();
            manager.savePlayersNow();
        }
    }

    public static void serverStarting(MinecraftServer server) {
        manager.registerCondition("always_active", (rank, json) -> AlwaysActiveCondition.INSTANCE);
        manager.registerCondition("rank_added", RankAddedCondition::new);
        manager.registerCondition("not", NotCondition::new);
        manager.registerCondition("or", OrCondition::new);
        manager.registerCondition("and", AndCondition::new);
        manager.registerCondition("xor", XorCondition::new);
        manager.registerCondition("op", (rank, tag) -> new OPCondition());
        manager.registerCondition("spawn", (rank, tag) -> new SpawnCondition());
        manager.registerCondition("dimension", (rank, tag) -> new DimensionCondition(tag));
        manager.registerCondition("playtime", (rank, tag) -> new PlaytimeCondition(tag));
        manager.registerCondition("stat", (rank, tag) -> new StatCondition(tag));
        manager.registerCondition("fake_player", (rank, tag) -> new FakePlayerCondition());
        manager.registerCondition("creative_mode", (rank, tag) -> new CreativeModeCondition());
    }

    public static EventResult serverChat(ServerPlayer player, TextFilter.FilteredText eventMessage, ChatEvent.ChatComponent component) {
        TextComponent cachedNameForChat;
        String format = FTBRanksAPI.getPermissionValue(player, "ftbranks.name_format").asString().orElse("");
        if (format.isEmpty()) {
            return EventResult.pass();
        }
        TextComponent main = new TextComponent("");
        try {
            cachedNameForChat = TextComponentParser.parse(format, s -> {
                if (s.equals("name")) {
                    return player.m_5446_();
                }
                return null;
            });
        }
        catch (Exception ex) {
            String s2 = "Error parsing " + format + ": " + ex;
            FTBRanks.LOGGER.error(s2);
            cachedNameForChat = new TextComponent("BrokenFormatting");
            cachedNameForChat.m_130940_(ChatFormatting.RED);
            cachedNameForChat.m_6270_(cachedNameForChat.m_7383_().m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent(s2))));
        }
        main.m_7220_((Component)cachedNameForChat);
        main.m_130946_(" ");
        ChatFormatting color = ChatFormatting.m_126657_((String)FTBRanksAPI.getPermissionValue(player, "ftbranks.chat_text.color").asString().orElse(null));
        TranslatableComponent fullComp = (TranslatableComponent)component.getFiltered();
        for (int i = 1; i < fullComp.m_131329_().length; ++i) {
            TextComponent part;
            TextComponent textComponent = part = fullComp.m_131329_()[i] instanceof Component ? (TextComponent)fullComp.m_131329_()[i] : new TextComponent((String)fullComp.m_131329_()[i]);
            if (color != null) {
                part.m_6270_(part.m_7383_().m_131157_(color));
            }
            if (FTBRanksAPI.getPermissionValue(player, "ftbranks.chat_text.bold").asBooleanOrFalse()) {
                part.m_6270_(part.m_7383_().m_131157_(ChatFormatting.BOLD));
            }
            if (FTBRanksAPI.getPermissionValue(player, "ftbranks.chat_text.italic").asBooleanOrFalse()) {
                part.m_6270_(part.m_7383_().m_131157_(ChatFormatting.ITALIC));
            }
            if (FTBRanksAPI.getPermissionValue(player, "ftbranks.chat_text.underlined").asBooleanOrFalse()) {
                part.m_6270_(part.m_7383_().m_131157_(ChatFormatting.UNDERLINE));
            }
            if (FTBRanksAPI.getPermissionValue(player, "ftbranks.chat_text.strikethrough").asBooleanOrFalse()) {
                part.m_6270_(part.m_7383_().m_131157_(ChatFormatting.STRIKETHROUGH));
            }
            if (FTBRanksAPI.getPermissionValue(player, "ftbranks.chat_text.obfuscated").asBooleanOrFalse()) {
                part.m_6270_(part.m_7383_().m_131157_(ChatFormatting.OBFUSCATED));
            }
            main.m_7220_((Component)part);
        }
        component.setFiltered((Component)main);
        return EventResult.interruptTrue();
    }
}

