/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbranks.api.Rank;
import dev.ftb.mods.ftbranks.impl.FTBRanksAPIImpl;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;

public class FTBRanksCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ftbranks").requires(source -> source.m_81377_().m_129792_() || source.m_6761_(2))).then(Commands.m_82127_((String)"reload").executes(context -> FTBRanksCommands.reloadRanks((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"refresh_readme").executes(context -> FTBRanksCommands.refreshReadme((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"list_all_ranks").executes(context -> FTBRanksCommands.listAllRanks((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> FTBRanksCommands.createRank((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"rank", (ArgumentType)StringArgumentType.word()).executes(context -> FTBRanksCommands.deleteRank((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank")))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).then(Commands.m_82129_((String)"rank", (ArgumentType)StringArgumentType.word()).executes(context -> FTBRanksCommands.addRank((CommandSourceStack)context.getSource(), GameProfileArgument.m_94590_((CommandContext)context, (String)"players"), StringArgumentType.getString((CommandContext)context, (String)"rank"))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).then(Commands.m_82129_((String)"rank", (ArgumentType)StringArgumentType.word()).executes(context -> FTBRanksCommands.removeRank((CommandSourceStack)context.getSource(), GameProfileArgument.m_94590_((CommandContext)context, (String)"players"), StringArgumentType.getString((CommandContext)context, (String)"rank"))))))).then(Commands.m_82127_((String)"list_ranks_of").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> FTBRanksCommands.listRanksOf((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"list_players_with").then(Commands.m_82129_((String)"rank", (ArgumentType)StringArgumentType.word()).executes(context -> FTBRanksCommands.listPlayersWith((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank"))))));
    }

    private static String normalizeRankName(String name) {
        return name.toLowerCase().replace("+", "_plus").replaceAll("[^a-z0-9_]", "_").replaceAll("_{2,}", "_");
    }

    private static int reloadRanks(CommandSourceStack source) {
        try {
            FTBRanksAPIImpl.manager.reload();
            source.m_81354_((Component)new TextComponent("Ranks reloaded!"), true);
            for (ServerPlayer p : source.m_81377_().m_6846_().m_11314_()) {
                source.m_81377_().m_6846_().m_11289_(p);
            }
            return 1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            source.m_81352_((Component)new TextComponent(ex.getLocalizedMessage()));
            return 0;
        }
    }

    private static int refreshReadme(CommandSourceStack source) {
        try {
            FTBRanksAPIImpl.manager.refreshReadme();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        source.m_81354_((Component)new TextComponent("Done!"), false);
        return 1;
    }

    private static int listAllRanks(CommandSourceStack source) {
        source.m_81354_((Component)new TextComponent("Ranks:"), false);
        for (Rank rank : FTBRanksAPIImpl.manager.getAllRanks()) {
            source.m_81354_((Component)new TextComponent("- " + rank.getName()).m_130940_(rank.getCondition().isDefaultCondition() ? ChatFormatting.AQUA : ChatFormatting.YELLOW), false);
        }
        return 1;
    }

    private static int createRank(CommandSourceStack source, String name) throws CommandSyntaxException {
        String id = FTBRanksCommands.normalizeRankName(name);
        if (FTBRanksAPIImpl.manager.getRank(id).isPresent()) {
            source.m_81352_((Component)new TextComponent("Rank ID already taken!"));
            return 0;
        }
        FTBRanksAPIImpl.manager.createRank(id, name);
        source.m_81354_((Component)new TextComponent("Rank created with id '" + id + "'!"), false);
        return 1;
    }

    private static int deleteRank(CommandSourceStack source, String name) throws CommandSyntaxException {
        if (FTBRanksAPIImpl.manager.deleteRank(FTBRanksCommands.normalizeRankName(name)) == null) {
            source.m_81352_((Component)new TextComponent("Rank not found!"));
            return 0;
        }
        source.m_81354_((Component)new TextComponent("Rank deleted!"), false);
        return 1;
    }

    private static int addRank(CommandSourceStack source, Collection<GameProfile> players, String name) throws CommandSyntaxException {
        Rank r = FTBRanksAPIImpl.manager.getRank(FTBRanksCommands.normalizeRankName(name)).orElseThrow(NullPointerException::new);
        for (GameProfile profile : players) {
            if (!r.add(profile)) continue;
            source.m_81354_((Component)new TextComponent("Added '" + r.getName() + "' to " + profile.getName()), false);
        }
        return 1;
    }

    private static int removeRank(CommandSourceStack source, Collection<GameProfile> players, String name) throws CommandSyntaxException {
        Rank r = FTBRanksAPIImpl.manager.getRank(FTBRanksCommands.normalizeRankName(name)).orElseThrow(NullPointerException::new);
        for (GameProfile profile : players) {
            if (!r.remove(profile)) continue;
            source.m_81354_((Component)new TextComponent("Removed '" + r.getName() + "' from " + profile.getName()), false);
        }
        return 1;
    }

    private static int listRanksOf(CommandSourceStack source, ServerPlayer player) {
        source.m_81354_((Component)new TextComponent("Ranks added to " + player.m_36316_().getName() + ":"), false);
        for (Rank rank : FTBRanksAPIImpl.manager.getAllRanks()) {
            if (!rank.isActive(player)) continue;
            source.m_81354_((Component)new TextComponent("- " + rank.getName()).m_130940_(rank.getCondition().isDefaultCondition() ? ChatFormatting.AQUA : ChatFormatting.YELLOW), false);
        }
        return 1;
    }

    private static int listPlayersWith(CommandSourceStack source, String name) {
        Rank r = FTBRanksAPIImpl.manager.getRank(FTBRanksCommands.normalizeRankName(name)).orElseThrow(NullPointerException::new);
        source.m_81354_((Component)new TextComponent("Players with " + name + " added to them:"), false);
        for (ServerPlayer player : source.m_81377_().m_6846_().m_11314_()) {
            if (!r.isActive(player)) continue;
            source.m_81354_((Component)new TextComponent("- ").m_130940_(ChatFormatting.YELLOW).m_7220_(player.m_5446_()), false);
        }
        return 1;
    }
}

