/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.malum;

import bl4ckscor3.mod.ceilingtorch.CeilingTorch;
import bl4ckscor3.mod.ceilingtorch.ICeilingTorchCompat;
import bl4ckscor3.mod.ceilingtorch.compat.malum.CeilingEtherTorchBlock;
import bl4ckscor3.mod.ceilingtorch.compat.malum.CeilingEtherTorchBlockEntity;
import bl4ckscor3.mod.ceilingtorch.compat.malum.MalumCompatClient;
import com.google.common.collect.ImmutableMap;
import com.sammy.malum.common.item.ether.AbstractEtherItem;
import com.sammy.malum.core.setup.content.block.BlockRegistry;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public class MalumCompat
implements ICeilingTorchCompat {
    public static Block etherCeilingTorch;
    public static Block iridescentEtherCeilingTorch;
    public static final RegistryObject<BlockEntityType<?>> ETHER_CEILING_TORCH;
    private Map<ResourceLocation, Block> placeEntries;

    public MalumCompat() {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> MalumCompatClient::addListeners);
    }

    @Override
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        etherCeilingTorch = (Block)new CeilingEtherTorchBlock(this.getProperties(), (Supplier<Block>)BlockRegistry.ETHER_TORCH).setRegistryName("malum_ether_torch");
        event.getRegistry().register((IForgeRegistryEntry)etherCeilingTorch);
        iridescentEtherCeilingTorch = (Block)new CeilingEtherTorchBlock(this.getProperties(), (Supplier<Block>)BlockRegistry.IRIDESCENT_ETHER_TORCH).setRegistryName("malum_iridescent_ether_torch");
        event.getRegistry().register((IForgeRegistryEntry)iridescentEtherCeilingTorch);
    }

    @Override
    public Map<ResourceLocation, Block> getPlaceEntries() {
        if (this.placeEntries == null) {
            this.placeEntries = ImmutableMap.of((Object)((Block)BlockRegistry.ETHER_TORCH.get()).getRegistryName(), (Object)etherCeilingTorch, (Object)((Block)BlockRegistry.IRIDESCENT_ETHER_TORCH.get()).getRegistryName(), (Object)iridescentEtherCeilingTorch);
        }
        return this.placeEntries;
    }

    @Override
    public BlockState getStateToPlace(PlayerInteractEvent.RightClickBlock event, Level level, BlockPos pos, BlockState state, ItemStack stack) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
    }

    @Override
    public void onPlace(PlayerInteractEvent.RightClickBlock event, BlockPos placeAt, BlockState state) {
        BlockEntity blockEntity = event.getWorld().m_7702_(placeAt);
        if (blockEntity instanceof CeilingEtherTorchBlockEntity) {
            CeilingEtherTorchBlockEntity be = (CeilingEtherTorchBlockEntity)blockEntity;
            ItemStack held = event.getItemStack();
            AbstractEtherItem item = (AbstractEtherItem)held.m_41720_();
            be.setFirstColor(item.getFirstColor(held));
            be.setSecondColor(item.getSecondColor(held));
        }
    }

    private BlockBehaviour.Properties getProperties() {
        return BlockRegistry.RUNEWOOD_PROPERTIES().noCollission().instabreak().lightLevel(state -> 14);
    }

    static {
        ETHER_CEILING_TORCH = CeilingTorch.BLOCK_ENTITIES.register("malum_ether_torch", () -> BlockEntityType.Builder.m_155273_(CeilingEtherTorchBlockEntity::new, (Block[])new Block[]{etherCeilingTorch, iridescentEtherCeilingTorch}).m_58966_(null));
    }
}

