/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.ilikewood;

import bl4ckscor3.mod.ceilingtorch.compat.vanilla.CeilingTorchBlock;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;

public class WoodenCeilingTorchBlock
extends CeilingTorchBlock
implements IWooden {
    protected static final VoxelShape CEILING_SHAPE = Block.m_49796_((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    protected final IWoodType woodType;
    protected final WoodenBlockType blockType;

    public WoodenCeilingTorchBlock(IWoodType woodType, WoodenBlockType blockType) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)WoodenCeilingTorchBlock.getVanillaTorchForWoodenBlockType(blockType)), (ParticleOptions)ParticleTypes.f_123762_, () -> ILikeWood.getBlock((IWoodType)woodType, (WoodenBlockType)blockType));
        this.woodType = woodType;
        this.blockType = blockType;
        this.setRegistryName(new ResourceLocation("ceilingtorch", "ilikewood_" + woodType.getName() + "_" + blockType.getName()));
    }

    public IWoodType getWoodType() {
        return this.woodType;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CEILING_SHAPE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level level, BlockPos pos, Random rand) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.1;
        double z = (double)pos.m_123343_() + 0.5;
        level.m_7106_(this.f_57488_, x, y, z, 0.0, 0.0, 0.0);
    }

    private static Block getVanillaTorchForWoodenBlockType(WoodenBlockType type) {
        if (type == WoodenBlockType.TORCH) {
            return Blocks.f_50081_;
        }
        if (type == WoodenBlockType.SOUL_TORCH) {
            return Blocks.f_50139_;
        }
        return Blocks.f_50016_;
    }
}

