/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch;

import bl4ckscor3.mod.ceilingtorch.ICeilingTorchCompat;
import bl4ckscor3.mod.ceilingtorch.compat.additionallights.AdditionalLightsCompat;
import bl4ckscor3.mod.ceilingtorch.compat.aquatictorches.AquaticTorchesCompat;
import bl4ckscor3.mod.ceilingtorch.compat.bonetorch.BoneTorchCompat;
import bl4ckscor3.mod.ceilingtorch.compat.ilikewood.ILikeWoodCompat;
import bl4ckscor3.mod.ceilingtorch.compat.integrateddynamics.IntegratedDynamicsCompat;
import bl4ckscor3.mod.ceilingtorch.compat.magicaltorches.MagicalTorchesCompat;
import bl4ckscor3.mod.ceilingtorch.compat.malum.MalumCompat;
import bl4ckscor3.mod.ceilingtorch.compat.moshiz.MoShizCompat;
import bl4ckscor3.mod.ceilingtorch.compat.nethersdelight.NethersDelightCompat;
import bl4ckscor3.mod.ceilingtorch.compat.pokecubeaio.PokecubeAIOCompat;
import bl4ckscor3.mod.ceilingtorch.compat.secretrooms.SecretRoomsCompat;
import bl4ckscor3.mod.ceilingtorch.compat.silentgear.SilentGearCompat;
import bl4ckscor3.mod.ceilingtorch.compat.tofucraft.TofuCraftCompat;
import bl4ckscor3.mod.ceilingtorch.compat.torchbandolier.TorchBandolierCompat;
import bl4ckscor3.mod.ceilingtorch.compat.torchmaster.TorchmasterCompat;
import bl4ckscor3.mod.ceilingtorch.compat.undergarden.UndergardenCompat;
import bl4ckscor3.mod.ceilingtorch.compat.vanilla.VanillaCompat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="ceilingtorch")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CeilingTorch {
    public static final String MODID = "ceilingtorch";
    private static final Map<String, ICeilingTorchCompat> COMPAT_LIST = new HashMap<String, ICeilingTorchCompat>();
    private static Map<String, Supplier<ICeilingTorchCompat>> preliminaryCompatList = new HashMap<String, Supplier<ICeilingTorchCompat>>();
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"ceilingtorch");

    public CeilingTorch() {
        BLOCK_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        preliminaryCompatList.put("minecraft", VanillaCompat::new);
        if (ModList.get().isLoaded("additional_lights")) {
            preliminaryCompatList.put("additional_lights", AdditionalLightsCompat::new);
        }
        if (ModList.get().isLoaded("aquatictorches")) {
            preliminaryCompatList.put("aquatictorches", AquaticTorchesCompat::new);
        }
        if (ModList.get().isLoaded("bonetorch")) {
            preliminaryCompatList.put("bonetorch", BoneTorchCompat::new);
        }
        if (ModList.get().isLoaded("ilikewood")) {
            preliminaryCompatList.put("ilikewood", ILikeWoodCompat::new);
        }
        if (ModList.get().isLoaded("integrateddynamics")) {
            preliminaryCompatList.put("integrateddynamics", IntegratedDynamicsCompat::new);
        }
        if (ModList.get().isLoaded("magical_torches")) {
            preliminaryCompatList.put("magical_torches", MagicalTorchesCompat::new);
        }
        if (ModList.get().isLoaded("malum")) {
            preliminaryCompatList.put("malum", MalumCompat::new);
        }
        if (ModList.get().isLoaded("ms")) {
            preliminaryCompatList.put("ms", MoShizCompat::new);
        }
        if (ModList.get().isLoaded("nethersdelight")) {
            preliminaryCompatList.put("nethersdelight", NethersDelightCompat::new);
        }
        if (ModList.get().isLoaded("pokecube_legends")) {
            preliminaryCompatList.put("pokecube_legends", PokecubeAIOCompat::new);
        }
        if (ModList.get().isLoaded("secretroomsmod")) {
            preliminaryCompatList.put("secretroomsmod", SecretRoomsCompat::new);
        }
        if (ModList.get().isLoaded("silentgear")) {
            preliminaryCompatList.put("silentgear", SilentGearCompat::new);
        }
        if (ModList.get().isLoaded("torchbandolier")) {
            preliminaryCompatList.put("torchbandolier", TorchBandolierCompat::new);
        }
        if (ModList.get().isLoaded("torchmaster")) {
            preliminaryCompatList.put("torchmaster", TorchmasterCompat::new);
        }
        if (ModList.get().isLoaded("tofucraft")) {
            preliminaryCompatList.put("tofucraft", TofuCraftCompat::new);
        }
        if (ModList.get().isLoaded("undergarden")) {
            preliminaryCompatList.put("undergarden", UndergardenCompat::new);
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Map.Entry<String, Supplier<ICeilingTorchCompat>> entry : preliminaryCompatList.entrySet()) {
            COMPAT_LIST.put(entry.getKey(), entry.getValue().get());
        }
        preliminaryCompatList = null;
        for (ICeilingTorchCompat compat : COMPAT_LIST.values()) {
            compat.registerBlocks(event);
        }
    }

    public static void addCompat(String modid, Supplier<ICeilingTorchCompat> compat) {
        if (ModList.get().isLoaded(modid)) {
            preliminaryCompatList.put(modid, compat);
        }
    }

    public static Map<String, ICeilingTorchCompat> getCompatList() {
        return COMPAT_LIST;
    }
}

