/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.util;

import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Math3DUtil {
    public static double yaw(Vec3 a, Vec3 b) {
        double dirx = a.f_82479_ - b.f_82479_;
        double diry = a.f_82480_ - b.f_82480_;
        double dirz = a.f_82481_ - b.f_82481_;
        double len = Math.sqrt(dirx * dirx + diry * diry + dirz * dirz);
        double pitch = Math.asin(diry /= len);
        double yaw = Math.atan2(dirz /= len, dirx /= len);
        pitch = pitch * 180.0 / Math.PI;
        yaw = yaw * 180.0 / Math.PI;
        return yaw += 90.0;
    }

    public static Vec3 center(BlockPos pos) {
        return new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public static BlockPos clamp(BlockPos pos, AABB bounds) {
        return new BlockPos(Mth.m_14008_((double)pos.m_123341_(), (double)bounds.f_82288_, (double)bounds.f_82291_), Mth.m_14008_((double)pos.m_123342_(), (double)bounds.f_82289_, (double)bounds.f_82292_), Mth.m_14008_((double)pos.m_123343_(), (double)bounds.f_82290_, (double)bounds.f_82293_));
    }

    public static AABB bounds(ChunkPos pos, int maxHeight) {
        return new AABB((double)pos.m_45604_(), 0.0, (double)pos.m_45605_(), (double)pos.m_45608_(), (double)maxHeight, (double)pos.m_45609_());
    }

    public static List<BlockPos> simpleTrace(BlockPos start, Direction direction, int distance) {
        return BlockPos.m_121990_((BlockPos)start, (BlockPos)start.m_5484_(direction, distance)).map(BlockPos::m_7949_).sorted(Comparator.comparingDouble(arg_0 -> ((BlockPos)start).m_123331_(arg_0))).collect(Collectors.toList());
    }

    public static BlockPos simpleTrace(BlockPos start, Direction direction, int distance, Predicate<BlockPos> hitCondition) {
        List<BlockPos> positions = Math3DUtil.simpleTrace(start, direction, distance);
        for (BlockPos pos : positions) {
            if (!hitCondition.test(pos)) continue;
            return pos;
        }
        return null;
    }
}

