/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.registry;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.CleanerJob;
import com.github.klikli_dev.occultism.common.job.ClearWeatherJob;
import com.github.klikli_dev.occultism.common.job.CrusherJob;
import com.github.klikli_dev.occultism.common.job.DayTimeJob;
import com.github.klikli_dev.occultism.common.job.LumberjackJob;
import com.github.klikli_dev.occultism.common.job.ManageMachineJob;
import com.github.klikli_dev.occultism.common.job.NightTimeJob;
import com.github.klikli_dev.occultism.common.job.RainWeatherJob;
import com.github.klikli_dev.occultism.common.job.SpiritJobFactory;
import com.github.klikli_dev.occultism.common.job.ThunderWeatherJob;
import com.github.klikli_dev.occultism.common.job.TraderJob;
import com.github.klikli_dev.occultism.common.job.TransportItemsJob;
import com.github.klikli_dev.occultism.util.StaticUtil;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class OccultismSpiritJobs {
    public static DeferredRegister<SpiritJobFactory> JOBS = DeferredRegister.create((ResourceLocation)new ResourceLocation("occultism", "spirit_job_factory"), (String)"occultism");
    public static final Supplier<IForgeRegistry<SpiritJobFactory>> REGISTRY = JOBS.makeRegistry(SpiritJobFactory.class, RegistryBuilder::new);
    public static final RegistryObject<SpiritJobFactory> LUMBERJACK = JOBS.register("lumberjack", () -> new SpiritJobFactory(LumberjackJob::new));
    public static final RegistryObject<SpiritJobFactory> MANAGE_MACHINE = JOBS.register("manage_machine", () -> new SpiritJobFactory(ManageMachineJob::new));
    public static final RegistryObject<SpiritJobFactory> TRANSPORT_ITEMS = JOBS.register("transport_items", () -> new SpiritJobFactory(TransportItemsJob::new));
    public static final RegistryObject<SpiritJobFactory> CLEANER = JOBS.register("cleaner", () -> new SpiritJobFactory(CleanerJob::new));
    public static final RegistryObject<SpiritJobFactory> TRADE_OTHERSTONE_T1 = JOBS.register("trade_otherstone_t1", () -> new SpiritJobFactory(entity -> {
        TraderJob job = new TraderJob((SpiritEntity)entity, StaticUtil.modLoc("spirit_trade/stone_to_otherstone"));
        job.setTimeToConvert(15);
        job.setMaxTradesPerRound(4);
        return job;
    }));
    public static final RegistryObject<SpiritJobFactory> TRADE_OTHERWORLD_SAPLINGS_T2 = JOBS.register("trade_otherworld_saplings_t1", () -> new SpiritJobFactory(entity -> {
        TraderJob job = new TraderJob((SpiritEntity)entity, StaticUtil.modLoc("spirit_trade/otherworld_sapling"));
        job.setTimeToConvert(20);
        job.setMaxTradesPerRound(1);
        return job;
    }));
    public static final RegistryObject<SpiritJobFactory> CRUSH_TIER1 = JOBS.register("crush_tier1", () -> new SpiritJobFactory(entity -> new CrusherJob((SpiritEntity)entity, () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier1CrusherTimeMultiplier.get()).floatValue()), () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier1CrusherOutputMultiplier.get()).floatValue()))));
    public static final RegistryObject<SpiritJobFactory> CRUSH_TIER2 = JOBS.register("crush_tier2", () -> new SpiritJobFactory(entity -> new CrusherJob((SpiritEntity)entity, () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier2CrusherTimeMultiplier.get()).floatValue()), () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier2CrusherOutputMultiplier.get()).floatValue()))));
    public static final RegistryObject<SpiritJobFactory> CRUSH_TIER3 = JOBS.register("crush_tier3", () -> new SpiritJobFactory(entity -> new CrusherJob((SpiritEntity)entity, () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier3CrusherTimeMultiplier.get()).floatValue()), () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier3CrusherOutputMultiplier.get()).floatValue()))));
    public static final RegistryObject<SpiritJobFactory> CRUSH_TIER4 = JOBS.register("crush_tier4", () -> new SpiritJobFactory(entity -> new CrusherJob((SpiritEntity)entity, () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier4CrusherTimeMultiplier.get()).floatValue()), () -> Float.valueOf(((Double)Occultism.SERVER_CONFIG.spiritJobs.tier4CrusherOutputMultiplier.get()).floatValue()))));
    public static final RegistryObject<SpiritJobFactory> CLEAR_WEATHER = JOBS.register("clear_weather", () -> new SpiritJobFactory(entity -> new ClearWeatherJob((SpiritEntity)entity, 300)));
    public static final RegistryObject<SpiritJobFactory> RAIN_WEATHER = JOBS.register("rain_weather", () -> new SpiritJobFactory(entity -> new RainWeatherJob((SpiritEntity)entity, 600)));
    public static final RegistryObject<SpiritJobFactory> THUNDER_WEATHER = JOBS.register("thunder_weather", () -> new SpiritJobFactory(entity -> new ThunderWeatherJob((SpiritEntity)entity, 1200)));
    public static final RegistryObject<SpiritJobFactory> DAY_TIME = JOBS.register("day_time", () -> new SpiritJobFactory(entity -> new DayTimeJob((SpiritEntity)entity, 600)));
    public static final RegistryObject<SpiritJobFactory> NIGHT_TIME = JOBS.register("night_time", () -> new SpiritJobFactory(entity -> new NightTimeJob((SpiritEntity)entity, 1200)));
}

