/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.github.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.github.klikli_dev.occultism.api.common.data.SortDirection;
import com.github.klikli_dev.occultism.api.common.data.SortType;
import com.github.klikli_dev.occultism.common.container.storage.StableWormholeContainer;
import com.github.klikli_dev.occultism.common.container.storage.StorageControllerContainer;
import com.github.klikli_dev.occultism.common.container.storage.StorageRemoteContainer;
import com.github.klikli_dev.occultism.network.MessageBase;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class MessageUpdateStorageSettings
extends MessageBase {
    private SortDirection sortDirection;
    private SortType sortType;

    public MessageUpdateStorageSettings(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageUpdateStorageSettings(SortDirection sortDirection, SortType sortType) {
        this.sortDirection = sortDirection;
        this.sortType = sortType;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player, NetworkEvent.Context context) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof IStorageControllerContainer) {
            StorageRemoteContainer storageRemoteContainer;
            ItemStack remote;
            IStorageControllerContainer storageContainer = (IStorageControllerContainer)abstractContainerMenu;
            IStorageController storageController = storageContainer.getStorageController();
            if (storageContainer instanceof StorageRemoteContainer && (remote = (storageRemoteContainer = (StorageRemoteContainer)storageContainer).getStorageRemote()) != ItemStack.f_41583_) {
                remote.m_41784_().m_128405_("sortDirection", this.sortDirection.getValue());
                remote.m_41784_().m_128405_("sortType", this.sortType.getValue());
                player.f_36096_.m_38946_();
            }
            if (storageContainer instanceof StorageControllerContainer) {
                StorageControllerContainer storageControllerContainer = (StorageControllerContainer)storageContainer;
                storageControllerContainer.getStorageController().setSortDirection(this.sortDirection);
                storageControllerContainer.getStorageController().setSortType(this.sortType);
                storageControllerContainer.getStorageController().markNetworkDirty();
            }
            if (storageContainer instanceof StableWormholeContainer) {
                StableWormholeContainer stableWormholeContainer = (StableWormholeContainer)storageContainer;
                stableWormholeContainer.getStableWormhole().setSortDirection(this.sortDirection);
                stableWormholeContainer.getStableWormhole().setSortType(this.sortType);
                stableWormholeContainer.getStableWormhole().markNetworkDirty();
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.sortDirection);
        buf.m_130068_((Enum)this.sortType);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.sortDirection = (SortDirection)buf.m_130066_(SortDirection.class);
        this.sortType = (SortType)buf.m_130066_(SortType.class);
    }
}

