/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.common.ritual.pentacle.Pentacle;
import com.github.klikli_dev.occultism.common.ritual.pentacle.PentacleManager;
import com.github.klikli_dev.occultism.network.MessageBase;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class MessageUpdatePentacles
extends MessageBase {
    private Map<ResourceLocation, Pentacle> pentacles;

    public MessageUpdatePentacles(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageUpdatePentacles(Map<ResourceLocation, Pentacle> pentacles) {
        this.pentacles = pentacles;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.pentacles.size());
        for (Map.Entry<ResourceLocation, Pentacle> entry : this.pentacles.entrySet()) {
            Pentacle pentacle = entry.getValue();
            buffer.m_130085_(entry.getKey());
            pentacle.toNetwork(buffer);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.pentacles = new HashMap<ResourceLocation, Pentacle>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buffer.m_130281_();
            Pentacle pentacle = Pentacle.fromNetwork(key, buffer);
            this.pentacles.put(key, pentacle);
        }
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player, NetworkEvent.Context context) {
        UpdatePentacles.update(this.pentacles).run();
    }

    private static class UpdatePentacles {
        private UpdatePentacles() {
        }

        private static DistExecutor.SafeRunnable update(final Map<ResourceLocation, Pentacle> pentacles) {
            return new DistExecutor.SafeRunnable(){
                private static final long serialVersionUID = 1L;

                public void run() {
                    PentacleManager.getInstance().setPentacles(pentacles);
                }
            };
        }
    }
}

