/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.api.common.blockentity.IStorageAccessor;
import com.github.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.github.klikli_dev.occultism.api.common.data.SortDirection;
import com.github.klikli_dev.occultism.api.common.data.SortType;
import com.github.klikli_dev.occultism.network.MessageBase;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class MessageSortItems
extends MessageBase {
    private BlockPos entityPosition;
    private SortDirection sortDirection;
    private SortType sortType;

    public MessageSortItems(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageSortItems(BlockPos entityPosition, SortDirection sortDirection, SortType sortType) {
        this.entityPosition = entityPosition;
        this.sortDirection = sortDirection;
        this.sortType = sortType;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player, NetworkEvent.Context context) {
        if (player.f_36096_ instanceof IStorageControllerContainer) {
            if (!((IStorageControllerContainer)player.f_36096_).isContainerItem()) {
                if (!player.f_19853_.m_46805_(this.entityPosition)) {
                    return;
                }
                BlockEntity blockEntity = player.f_19853_.m_7702_(this.entityPosition);
                if (blockEntity instanceof IStorageAccessor) {
                    IStorageAccessor storageAccessor = (IStorageAccessor)blockEntity;
                    storageAccessor.setSortType(this.sortType);
                    storageAccessor.setSortDirection(this.sortDirection);
                    blockEntity.m_6596_();
                }
            } else {
                ItemStack stack = player.m_150109_().m_36056_();
                stack.m_41784_().m_128405_("sortDirection", this.sortDirection.getValue());
                stack.m_41783_().m_128405_("sortType", this.sortType.getValue());
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.m_130064_(this.entityPosition);
        byteBuf.writeByte(this.sortDirection.getValue());
        byteBuf.writeByte(this.sortType.getValue());
    }

    @Override
    public void decode(FriendlyByteBuf byteBuf) {
        this.entityPosition = byteBuf.m_130135_();
        this.sortDirection = SortDirection.get(byteBuf.readByte());
        this.sortType = SortType.get(byteBuf.readByte());
    }
}

