/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.integration.jei.recipes;

import com.github.klikli_dev.occultism.crafting.recipe.MinerRecipe;
import com.github.klikli_dev.occultism.integration.jei.JeiRecipeTypes;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class MinerRecipeCategory
implements IRecipeCategory<MinerRecipe> {
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable overlay;
    private final Map<MinerRecipe, Float> chances = new HashMap<MinerRecipe, Float>();

    public MinerRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(168, 46);
        this.localizedName = new TranslatableComponent("occultism.jei.miner");
        this.overlay = guiHelper.createDrawable(new ResourceLocation("occultism", "textures/gui/jei/arrow.png"), 0, 0, 64, 46);
    }

    protected void drawStringCentered(PoseStack poseStack, Font fontRenderer, Component text, int x, int y) {
        fontRenderer.m_92889_(poseStack, text, (float)x - (float)fontRenderer.m_92852_((FormattedText)text) / 2.0f, (float)y, 0);
    }

    public RecipeType<MinerRecipe> getRecipeType() {
        return JeiRecipeTypes.MINER;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MinerRecipe recipe, IFocusGroup focuses) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        ItemStackHandler simulatedHandler = new ItemStackHandler(1);
        simulatedHandler.setStackInSlot(0, ((Ingredient)recipe.m_7527_().get(0)).m_43908_()[0]);
        List recipes = level.m_7465_().m_44056_((net.minecraft.world.item.crafting.RecipeType)OccultismRecipes.MINER_TYPE.get(), (Container)new RecipeWrapper((IItemHandlerModifiable)simulatedHandler), (Level)level);
        List possibleResults = recipes.stream().map(MinerRecipe::getWeightedOutput).collect(Collectors.toList());
        float chance = (float)recipe.getWeightedOutput().m_142631_().m_146281_() / (float)WeightedRandom.m_146312_(possibleResults) * 100.0f;
        chance = (float)Math.round(chance * 10.0f) / 10.0f;
        this.chances.put(recipe, Float.valueOf(chance));
        builder.addSlot(RecipeIngredientRole.INPUT, 56, 12).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 94, 12).addItemStack(recipe.m_8043_());
    }

    public void draw(MinerRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        RenderSystem.m_69478_();
        this.overlay.draw(stack, 76, 14);
        this.drawStringCentered(stack, Minecraft.m_91087_().f_91062_, (Component)new TranslatableComponent("occultism.jei.miner.chance", new Object[]{this.chances.get(recipe)}), 84, 0);
    }

    public ResourceLocation getUid() {
        return OccultismRecipes.MINER.getId();
    }

    public Class<? extends MinerRecipe> getRecipeClass() {
        return MinerRecipe.class;
    }
}

