/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.integration.jei;

import com.github.klikli_dev.occultism.network.MessageSetRecipe;
import com.github.klikli_dev.occultism.network.MessageSetRecipeByID;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;

public class StorageControllerRecipeTransferHandler<T extends AbstractContainerMenu>
implements IRecipeTransferHandler<T, CraftingRecipe> {
    protected final Class<T> containerClass;
    protected final IRecipeTransferHandlerHelper handlerHelper;

    public StorageControllerRecipeTransferHandler(Class<T> containerClass, IRecipeTransferHandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
        this.containerClass = containerClass;
    }

    public Class<T> getContainerClass() {
        return this.containerClass;
    }

    public Class<CraftingRecipe> getRecipeClass() {
        return CraftingRecipe.class;
    }

    public IRecipeTransferError transferRecipe(T container, CraftingRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (recipe.m_6423_() == null) {
            return this.handlerHelper.createUserErrorWithTooltip((Component)new TranslatableComponent("jei.occultismerror.missing_id"));
        }
        if (!recipe.m_8004_(3, 3)) {
            return this.handlerHelper.createUserErrorWithTooltip((Component)new TranslatableComponent("jei.occultismerror.recipe_too_large"));
        }
        if (doTransfer) {
            if (player.m_20193_().m_7465_().m_44043_(recipe.m_6423_()).isPresent()) {
                OccultismPackets.sendToServer(new MessageSetRecipeByID(recipe.m_6423_()));
            } else {
                OccultismPackets.sendToServer(new MessageSetRecipe(this.recipeToNbt((AbstractContainerMenu)container, recipeSlots)));
            }
        }
        return null;
    }

    public CompoundTag recipeToNbt(AbstractContainerMenu container, IRecipeSlotsView recipeSlots) {
        CompoundTag nbt = new CompoundTag();
        List slotsViewList = recipeSlots.getSlotViews();
        for (Slot slot : container.f_38839_) {
            List possibleItems;
            IRecipeSlotView slotView;
            if (!(slot.f_40218_ instanceof CraftingContainer) || (slotView = (IRecipeSlotView)slotsViewList.get(slot.getSlotIndex() + 1)) == null || (possibleItems = slotView.getIngredients(VanillaTypes.ITEM).collect(Collectors.toList())).isEmpty()) continue;
            ListTag invList = new ListTag();
            for (int i = 0; i < possibleItems.size() && i < 5; ++i) {
                ItemStack itemStack = (ItemStack)possibleItems.get(i);
                if (itemStack.m_41619_()) continue;
                invList.add((Object)itemStack.serializeNBT());
            }
            nbt.m_128365_("s" + slot.getSlotIndex(), (Tag)invList);
        }
        return nbt;
    }
}

