/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.handlers;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.client.gui.DimensionalMineshaftScreen;
import com.github.klikli_dev.occultism.client.gui.spirit.SpiritGui;
import com.github.klikli_dev.occultism.client.gui.spirit.SpiritTransporterGui;
import com.github.klikli_dev.occultism.client.gui.storage.SatchelScreen;
import com.github.klikli_dev.occultism.client.gui.storage.StableWormholeGui;
import com.github.klikli_dev.occultism.client.gui.storage.StorageControllerGui;
import com.github.klikli_dev.occultism.client.gui.storage.StorageRemoteGui;
import com.github.klikli_dev.occultism.client.itemproperties.DivinationRodItemPropertyGetter;
import com.github.klikli_dev.occultism.client.itemproperties.GuideBookItemPropertyGetter;
import com.github.klikli_dev.occultism.client.itemproperties.OtherworldBlockItemPropertyGetter;
import com.github.klikli_dev.occultism.client.itemproperties.SoulGemItemPropertyGetter;
import com.github.klikli_dev.occultism.client.itemproperties.StableWormholeBlockItemPropertyGetter;
import com.github.klikli_dev.occultism.client.itemproperties.StorageRemoteItemPropertyGetter;
import com.github.klikli_dev.occultism.client.keybindings.BackpackKeyConflictContext;
import com.github.klikli_dev.occultism.client.keybindings.StorageRemoteKeyConflictContext;
import com.github.klikli_dev.occultism.client.model.entity.AfritModel;
import com.github.klikli_dev.occultism.client.model.entity.BatFamiliarModel;
import com.github.klikli_dev.occultism.client.model.entity.BeaverFamiliarModel;
import com.github.klikli_dev.occultism.client.model.entity.BeholderFamiliarModel;
import com.github.klikli_dev.occultism.client.model.entity.BlacksmithFamiliarModel;
import com.github.klikli_dev.occultism.client.model.entity.ChimeraFamiliarModel;
import com.github.klikli_dev.occultism.client.model.entity.CthulhuFamiliarModel;
import com.github.klikli_dev.occultism.client.model.entity.DeerFamiliarModel;
import com.github.klikli_dev.occultism.client.model.entity.DevilFamiliarModel;
import com.github.klikli_dev.occultism.client.model.entity.DjinniModel;
import com.github.klikli_dev.occultism.client.model.entity.DragonFamiliarModel;
import com.github.klikli_dev.occultism.client.model.entity.FairyFamiliarModel;
import com.github.klikli_dev.occultism.client.model.entity.FoliotModel;
import com.github.klikli_dev.occultism.client.model.entity.GoatFamiliarModel;
import com.github.klikli_dev.occultism.client.model.entity.GreedyFamiliarModel;
import com.github.klikli_dev.occultism.client.model.entity.GuardianFamiliarModel;
import com.github.klikli_dev.occultism.client.model.entity.HeadlessFamiliarModel;
import com.github.klikli_dev.occultism.client.model.entity.MaridModel;
import com.github.klikli_dev.occultism.client.model.entity.MummyFamiliarModel;
import com.github.klikli_dev.occultism.client.model.entity.ShubNiggurathFamiliarModel;
import com.github.klikli_dev.occultism.client.model.entity.ShubNiggurathSpawnModel;
import com.github.klikli_dev.occultism.client.render.ThirdEyeEffectRenderer;
import com.github.klikli_dev.occultism.client.render.blockentity.SacrificialBowlRenderer;
import com.github.klikli_dev.occultism.client.render.blockentity.StorageControllerGeoRenderer;
import com.github.klikli_dev.occultism.client.render.entity.AfritRenderer;
import com.github.klikli_dev.occultism.client.render.entity.BatFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.BeaverFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.BeholderFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.BlacksmithFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.ChimeraFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.CthulhuFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.DeerFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.DevilFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.DjinniRenderer;
import com.github.klikli_dev.occultism.client.render.entity.DragonFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.DragonRendering;
import com.github.klikli_dev.occultism.client.render.entity.FairyFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.FoliotRenderer;
import com.github.klikli_dev.occultism.client.render.entity.GoatFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.GreedyFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.GuardianFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.HeadlessFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.MaridRenderer;
import com.github.klikli_dev.occultism.client.render.entity.MummyFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.OtherworldBirdRenderer;
import com.github.klikli_dev.occultism.client.render.entity.ShubNiggurathFamiliarRenderer;
import com.github.klikli_dev.occultism.client.render.entity.ShubNiggurathSpawnRenderer;
import com.github.klikli_dev.occultism.common.capability.FamiliarSettingsCapability;
import com.github.klikli_dev.occultism.common.entity.IFamiliar;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismContainers;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.github.klikli_dev.occultism.registry.OccultismModelLayers;
import com.github.klikli_dev.occultism.registry.OccultismTiles;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EndermanRenderer;
import net.minecraft.client.renderer.entity.EndermiteRenderer;
import net.minecraft.client.renderer.entity.GhastRenderer;
import net.minecraft.client.renderer.entity.SkeletonRenderer;
import net.minecraft.client.renderer.entity.WitherSkeletonRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="occultism", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetupEventHandler {
    public static final KeyMapping KEY_BACKPACK = new KeyMapping("key.occultism.backpack", (IKeyConflictContext)BackpackKeyConflictContext.INSTANCE, InputConstants.Type.KEYSYM.m_84895_(66), "key.occultism.category");
    public static final KeyMapping KEY_STORAGE_REMOTE = new KeyMapping("key.occultism.storage_remote", (IKeyConflictContext)StorageRemoteKeyConflictContext.INSTANCE, InputConstants.Type.KEYSYM.m_84895_(78), "key.occultism.category");
    public static Map<EntityType<?>, KeyMapping> keysFamiliars;

    @SubscribeEvent
    public static void onRegisterEntityRendererLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(OccultismModelLayers.AFRIT, AfritModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.FAMILIAR_BAT, BatFamiliarModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.FAMILIAR_DEER, DeerFamiliarModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.FAMILIAR_GREEDY, GreedyFamiliarModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.FAMILIAR_CTHULHU, CthulhuFamiliarModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.FAMILIAR_DEVIL, DevilFamiliarModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.FAMILIAR_DRAGON, DragonFamiliarModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.FAMILIAR_BLACKSMITH, BlacksmithFamiliarModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.FAMILIAR_GUARDIAN, GuardianFamiliarModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.FAMILIAR_HEADLESS, HeadlessFamiliarModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.FAMILIAR_CHIMERA, ChimeraFamiliarModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.FAMILIAR_GOAT, GoatFamiliarModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.FAMILIAR_SHUB_NIGGURATH, ShubNiggurathFamiliarModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.FAMILIAR_SHUB_NIGGURATH_SPAWN, ShubNiggurathSpawnModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.FAMILIAR_BEHOLDER, BeholderFamiliarModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.FAMILIAR_FAIRY, FairyFamiliarModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.FAMILIAR_MUMMY, MummyFamiliarModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.FAMILIAR_BEAVER, BeaverFamiliarModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.DJINNI, DjinniModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.FOLIOT, FoliotModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.MARID, MaridModel::createBodyLayer);
        event.registerLayerDefinition(OccultismModelLayers.KAPOW, MummyFamiliarRenderer.KapowModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void onRegisterEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)OccultismEntities.FOLIOT.get(), FoliotRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.DJINNI.get(), DjinniRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.AFRIT.get(), AfritRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.AFRIT_WILD.get(), AfritRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.MARID.get(), MaridRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.GREEDY_FAMILIAR.get(), GreedyFamiliarRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.BAT_FAMILIAR.get(), BatFamiliarRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.DEER_FAMILIAR.get(), DeerFamiliarRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.CTHULHU_FAMILIAR.get(), CthulhuFamiliarRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.DEVIL_FAMILIAR.get(), DevilFamiliarRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.DRAGON_FAMILIAR.get(), DragonFamiliarRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.BLACKSMITH_FAMILIAR.get(), BlacksmithFamiliarRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.GUARDIAN_FAMILIAR.get(), GuardianFamiliarRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.HEADLESS_FAMILIAR.get(), HeadlessFamiliarRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.THROWN_SWORD.get(), DragonRendering.ThrownSwordRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.CHIMERA_FAMILIAR.get(), ChimeraFamiliarRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.SHUB_NIGGURATH_FAMILIAR.get(), ShubNiggurathFamiliarRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.BEHOLDER_FAMILIAR.get(), BeholderFamiliarRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.FAIRY_FAMILIAR.get(), FairyFamiliarRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.MUMMY_FAMILIAR.get(), MummyFamiliarRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.BEAVER_FAMILIAR.get(), BeaverFamiliarRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.GOAT_FAMILIAR.get(), GoatFamiliarRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.SHUB_NIGGURATH_SPAWN.get(), ShubNiggurathSpawnRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.POSSESSED_ENDERMITE.get(), EndermiteRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.POSSESSED_SKELETON.get(), SkeletonRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.POSSESSED_ENDERMAN.get(), EndermanRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.POSSESSED_GHAST.get(), GhastRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.WILD_HUNT_SKELETON.get(), SkeletonRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.WILD_HUNT_WITHER_SKELETON.get(), WitherSkeletonRenderer::new);
        event.registerEntityRenderer((EntityType)OccultismEntities.OTHERWORLD_BIRD.get(), OtherworldBirdRenderer::new);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)Occultism.SELECTED_BLOCK_RENDERER);
        MinecraftForge.EVENT_BUS.register((Object)Occultism.THIRD_EYE_EFFECT_RENDERER);
        event.enqueueWork(() -> {
            ClientRegistry.registerKeyBinding((KeyMapping)KEY_BACKPACK);
            ClientRegistry.registerKeyBinding((KeyMapping)KEY_STORAGE_REMOTE);
            keysFamiliars = new HashMap();
            for (EntityType<? extends IFamiliar> familiar : FamiliarSettingsCapability.getFamiliars()) {
                KeyMapping kb = new KeyMapping("key.occultism.familiar." + familiar.getRegistryName().m_135815_(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM.m_84895_(-1), "key.occultism.category");
                keysFamiliars.put(familiar, kb);
                ClientRegistry.registerKeyBinding((KeyMapping)kb);
            }
        });
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)OccultismTiles.STORAGE_CONTROLLER.get()), StorageControllerGeoRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)OccultismTiles.SACRIFICIAL_BOWL.get()), SacrificialBowlRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)OccultismTiles.GOLDEN_SACRIFICIAL_BOWL.get()), SacrificialBowlRenderer::new);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)OccultismBlocks.CHALK_GLYPH_WHITE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)OccultismBlocks.CHALK_GLYPH_GOLD.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)OccultismBlocks.CHALK_GLYPH_PURPLE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)OccultismBlocks.CHALK_GLYPH_RED.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)OccultismBlocks.STABLE_WORMHOLE.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)OccultismBlocks.DATURA.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)OccultismBlocks.SPIRIT_FIRE.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)OccultismBlocks.SPIRIT_TORCH.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)OccultismBlocks.SPIRIT_WALL_TORCH.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)OccultismBlocks.SPIRIT_LANTERN.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)OccultismBlocks.SPIRIT_CAMPFIRE.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)OccultismBlocks.OTHERWORLD_SAPLING.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)OccultismBlocks.OTHERWORLD_SAPLING_NATURAL.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)OccultismBlocks.OTHERWORLD_LEAVES.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)OccultismBlocks.OTHERWORLD_LEAVES_NATURAL.get()), (RenderType)RenderType.m_110457_());
        ClientSetupEventHandler.registerItemModelProperties(event);
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)OccultismContainers.STORAGE_CONTROLLER.get()), StorageControllerGui::new);
            MenuScreens.m_96206_((MenuType)((MenuType)OccultismContainers.STABLE_WORMHOLE.get()), StableWormholeGui::new);
            MenuScreens.m_96206_((MenuType)((MenuType)OccultismContainers.STORAGE_REMOTE.get()), StorageRemoteGui::new);
            MenuScreens.m_96206_((MenuType)((MenuType)OccultismContainers.SPIRIT.get()), SpiritGui::new);
            MenuScreens.m_96206_((MenuType)((MenuType)OccultismContainers.SPIRIT_TRANSPORTER.get()), SpiritTransporterGui::new);
            MenuScreens.m_96206_((MenuType)((MenuType)OccultismContainers.OTHERWORLD_MINER.get()), DimensionalMineshaftScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)OccultismContainers.SATCHEL.get()), SatchelScreen::new);
            Occultism.LOGGER.debug("Registered Screen Containers");
        });
        ThirdEyeEffectRenderer.THIRD_EYE_OVERLAY = OverlayRegistry.registerOverlayTop((String)"third_eye", (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
            gui.setupOverlayRenderState(true, false, ThirdEyeEffectRenderer.THIRD_EYE_TEXTURE);
            RenderSystem.m_69493_();
            Occultism.THIRD_EYE_EFFECT_RENDERER.renderOverlay(poseStack);
        });
        Occultism.LOGGER.debug("Registered Overlays");
        Occultism.LOGGER.info("Client setup complete.");
    }

    public static void registerItemModelProperties(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)OccultismItems.GUIDE_BOOK.get()), (ResourceLocation)new ResourceLocation("completion"), (ItemPropertyFunction)new GuideBookItemPropertyGetter());
            ItemProperties.register((Item)((Item)OccultismItems.SOUL_GEM_ITEM.get()), (ResourceLocation)new ResourceLocation("occultism", "has_entity"), (ItemPropertyFunction)new SoulGemItemPropertyGetter());
            ItemProperties.register((Item)((Item)OccultismItems.DIVINATION_ROD.get()), (ResourceLocation)new ResourceLocation("occultism", "distance"), (ItemPropertyFunction)new DivinationRodItemPropertyGetter());
            ItemProperties.register((Item)((Item)OccultismItems.OTHERWORLD_SAPLING_NATURAL.get()), (ResourceLocation)new ResourceLocation("occultism", "simulated"), (ItemPropertyFunction)new OtherworldBlockItemPropertyGetter());
            ItemProperties.register((Item)((Item)OccultismItems.STORAGE_REMOTE.get()), (ResourceLocation)new ResourceLocation("occultism", "linked"), (ItemPropertyFunction)new StorageRemoteItemPropertyGetter());
            ItemProperties.register((Item)((Item)OccultismItems.STABLE_WORMHOLE.get()), (ResourceLocation)new ResourceLocation("occultism", "linked"), (ItemPropertyFunction)new StableWormholeBlockItemPropertyGetter());
            Occultism.LOGGER.debug("Registered Item Properties");
        });
    }
}

