/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.handlers;

import com.github.klikli_dev.occultism.client.gui.storage.SatchelScreen;
import com.github.klikli_dev.occultism.client.gui.storage.StorageRemoteGui;
import com.github.klikli_dev.occultism.handlers.ClientSetupEventHandler;
import com.github.klikli_dev.occultism.network.MessageDoubleJump;
import com.github.klikli_dev.occultism.network.MessageOpenSatchel;
import com.github.klikli_dev.occultism.network.MessageOpenStorageRemote;
import com.github.klikli_dev.occultism.network.MessageToggleFamiliarSettings;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.util.CuriosUtil;
import com.github.klikli_dev.occultism.util.MovementUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="occultism", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientPlayerEventHandler {
    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientPlayerEventHandler.checkBackpackKey((InputEvent)event);
        ClientPlayerEventHandler.checkStorageRemoteKey((InputEvent)event);
        ClientPlayerEventHandler.checkFamiliarSettingsKeys((InputEvent)event);
        if (event.getAction() == 1 && minecraft.f_91066_.f_92089_.m_90857_() && minecraft.f_91074_ != null && MovementUtil.doubleJump((Player)minecraft.f_91074_)) {
            OccultismPackets.sendToServer(new MessageDoubleJump());
        }
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseInputEvent event) {
        ClientPlayerEventHandler.checkBackpackKey((InputEvent)event);
        ClientPlayerEventHandler.checkStorageRemoteKey((InputEvent)event);
        ClientPlayerEventHandler.checkFamiliarSettingsKeys((InputEvent)event);
    }

    public static void checkBackpackKey(InputEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91080_ instanceof SatchelScreen && ClientSetupEventHandler.KEY_BACKPACK.m_90859_()) {
            minecraft.f_91074_.m_6915_();
        } else if (minecraft.f_91074_ != null & minecraft.f_91080_ == null && ClientSetupEventHandler.KEY_BACKPACK.m_90859_() && (!CuriosUtil.getBackpack((Player)minecraft.f_91074_).m_41619_() || CuriosUtil.getFirstBackpackSlot((Player)minecraft.f_91074_) > 0)) {
            OccultismPackets.sendToServer(new MessageOpenSatchel());
            minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11678_, (float)0.75f, (float)1.0f));
        }
    }

    public static void checkStorageRemoteKey(InputEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91080_ instanceof StorageRemoteGui && ClientSetupEventHandler.KEY_STORAGE_REMOTE.m_90859_()) {
            minecraft.f_91074_.m_6915_();
        } else if (minecraft.f_91074_ != null & minecraft.f_91080_ == null && ClientSetupEventHandler.KEY_STORAGE_REMOTE.m_90859_() && (!CuriosUtil.getStorageRemoteCurio((Player)minecraft.f_91074_).m_41619_() || CuriosUtil.getFirstStorageRemoteSlot((Player)minecraft.f_91074_) > 0)) {
            OccultismPackets.sendToServer(new MessageOpenStorageRemote());
            minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11673_, (float)0.75f, (float)1.0f));
        }
    }

    public static void checkFamiliarSettingsKeys(InputEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null & minecraft.f_91080_ == null) {
            boolean familiarKeyPressed = false;
            HashMap familiarsPressed = new HashMap();
            for (Map.Entry<EntityType<?>, KeyMapping> entry : ClientSetupEventHandler.keysFamiliars.entrySet()) {
                boolean isPressed = entry.getValue().m_90859_();
                if (isPressed) {
                    familiarKeyPressed = true;
                }
                familiarsPressed.put(entry.getKey(), isPressed);
            }
            if (familiarKeyPressed) {
                OccultismPackets.sendToServer(new MessageToggleFamiliarSettings(familiarsPressed));
            }
        }
    }
}

