/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.crafting.recipe;

import com.github.klikli_dev.occultism.common.misc.WeightedIngredient;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MinerRecipe
implements Recipe<RecipeWrapper> {
    public static Serializer SERIALIZER = new Serializer();
    protected final ResourceLocation id;
    protected final Ingredient input;
    protected final WeightedIngredient output;

    public MinerRecipe(ResourceLocation id, Ingredient input, WeightedIngredient output) {
        this.input = input;
        this.output = output;
        this.id = id;
    }

    public WeightedIngredient getWeightedOutput() {
        return this.output;
    }

    public boolean matches(RecipeWrapper inv, Level level) {
        return this.input.test(inv.m_8020_(0));
    }

    public ItemStack assemble(RecipeWrapper inv) {
        return this.m_8043_().m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output.getStack();
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.input});
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)OccultismRecipes.MINER_TYPE.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<MinerRecipe> {
        public MinerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonArray ingredientElement = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientElement);
            JsonObject resultElement = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            Ingredient result = Ingredient.m_43917_((JsonElement)resultElement);
            int weight = GsonHelper.m_13927_((JsonObject)json, (String)"weight");
            return new MinerRecipe(recipeId, ingredient, new WeightedIngredient(result, weight));
        }

        public MinerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient result = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int weight = buffer.readInt();
            return new MinerRecipe(recipeId, ingredient, new WeightedIngredient(result, weight));
        }

        public void toNetwork(FriendlyByteBuf buffer, MinerRecipe recipe) {
            recipe.input.m_43923_(buffer);
            recipe.output.getIngredient().m_43923_(buffer);
            buffer.writeInt(recipe.output.m_142631_().m_146281_());
        }
    }
}

