/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.job;

import com.github.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.api.common.data.MachineReference;
import com.github.klikli_dev.occultism.common.entity.ai.DepositItemsGoal;
import com.github.klikli_dev.occultism.common.entity.ai.FallbackDepositToControllerGoal;
import com.github.klikli_dev.occultism.common.entity.ai.ManageMachineGoal;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.SpiritJob;
import com.github.klikli_dev.occultism.common.misc.DepositOrder;
import com.github.klikli_dev.occultism.util.BlockEntityUtil;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ManageMachineJob
extends SpiritJob {
    protected DepositItemsGoal depositItemsGoal;
    protected ManageMachineGoal manageMachineGoal;
    protected FallbackDepositToControllerGoal fallbackDepositToControllerGoal;
    protected OpenDoorGoal openDoorGoal;
    protected GlobalBlockPos storageControllerPosition;
    protected MachineReference managedMachine;
    protected DepositOrder currentDepositOrder;
    protected Queue<DepositOrder> depositOrderQueue = new ArrayDeque<DepositOrder>();
    protected IStorageController storageController;
    protected BlockEntity managedMachineBlockEntity;
    protected BlockEntity extractBlockEntity;

    public ManageMachineJob(SpiritEntity entity) {
        super(entity);
    }

    public DepositOrder getCurrentDepositOrder() {
        return this.currentDepositOrder;
    }

    public void setCurrentDepositOrder(DepositOrder order) {
        this.currentDepositOrder = order;
    }

    public MachineReference getManagedMachine() {
        return this.managedMachine;
    }

    public void setManagedMachine(MachineReference managedMachine) {
        if (this.managedMachine != null) {
            this.unregisterFromStorageController();
        }
        this.managedMachine = managedMachine;
        this.managedMachineBlockEntity = null;
        this.extractBlockEntity = null;
        this.clearAllOrders();
        this.registerWithStorageController();
    }

    public GlobalBlockPos getStorageControllerPosition() {
        return this.storageControllerPosition;
    }

    public void setStorageControllerPosition(GlobalBlockPos storageControllerPosition) {
        if (this.storageControllerPosition != null) {
            this.unregisterFromStorageController();
        }
        this.storageControllerPosition = storageControllerPosition;
        this.storageController = null;
        this.clearAllOrders();
        this.registerWithStorageController();
    }

    public IStorageController getStorageController() {
        if (this.storageControllerPosition == null) {
            return null;
        }
        if (this.storageController == null) {
            this.storageController = (IStorageController)BlockEntityUtil.get(this.entity.f_19853_, this.storageControllerPosition);
        }
        if (this.storageController == null) {
            this.storageControllerPosition = null;
        }
        return this.storageController;
    }

    public BlockEntity getManagedMachineBlockEntity() {
        if (this.managedMachine == null) {
            return null;
        }
        if (this.managedMachineBlockEntity == null) {
            this.managedMachineBlockEntity = BlockEntityUtil.get(this.entity.f_19853_, this.managedMachine.insertGlobalPos);
        }
        return this.managedMachineBlockEntity;
    }

    public BlockEntity getExtractBlockEntity() {
        if (this.managedMachine == null) {
            return null;
        }
        if (this.extractBlockEntity == null) {
            this.extractBlockEntity = BlockEntityUtil.get(this.entity.f_19853_, this.managedMachine.extractGlobalPos);
        }
        return this.extractBlockEntity;
    }

    @Override
    public void init() {
        this.entity.m_21573_().m_26575_().m_77351_(true);
        ((GroundPathNavigation)this.entity.m_21573_()).m_26477_(true);
        this.manageMachineGoal = new ManageMachineGoal(this.entity, this);
        this.entity.f_21345_.m_25352_(3, (Goal)this.manageMachineGoal);
        this.fallbackDepositToControllerGoal = new FallbackDepositToControllerGoal(this.entity, this);
        this.entity.f_21345_.m_25352_(4, (Goal)this.fallbackDepositToControllerGoal);
        this.depositItemsGoal = new DepositItemsGoal(this.entity);
        this.entity.f_21345_.m_25352_(4, (Goal)this.depositItemsGoal);
        this.openDoorGoal = new OpenDoorGoal((Mob)this.entity, true);
        this.entity.f_21345_.m_25352_(5, (Goal)this.openDoorGoal);
        this.registerWithStorageController();
    }

    @Override
    public void cleanup() {
        this.entity.m_21573_().m_26575_().m_77351_(false);
        ((GroundPathNavigation)this.entity.m_21573_()).m_26477_(false);
        this.entity.f_21345_.m_25363_((Goal)this.depositItemsGoal);
        this.entity.f_21345_.m_25363_((Goal)this.manageMachineGoal);
        this.entity.f_21345_.m_25363_((Goal)this.openDoorGoal);
        this.entity.f_21345_.m_25363_((Goal)this.fallbackDepositToControllerGoal);
        this.unregisterFromStorageController();
    }

    @Override
    public void update() {
        if (this.storageControllerPosition != null && this.managedMachine != null && this.getCurrentDepositOrder() == null && !this.depositOrderQueue.isEmpty()) {
            this.setCurrentDepositOrder(this.depositOrderQueue.poll());
        }
        if (this.currentDepositOrder != null && this.currentDepositOrder.comparator == null) {
            this.setCurrentDepositOrder(null);
        }
    }

    @Override
    public CompoundTag writeJobToNBT(CompoundTag compound) {
        if (this.storageControllerPosition != null) {
            compound.m_128365_("storageControllerPosition", (Tag)this.storageControllerPosition.serializeNBT());
        }
        if (this.managedMachine != null) {
            compound.m_128365_("managedMachine", (Tag)this.managedMachine.serializeNBT());
        }
        if (this.getCurrentDepositOrder() != null) {
            compound.m_128365_("currentDepositOrder", (Tag)this.getCurrentDepositOrder().writeToNBT(new CompoundTag()));
        }
        ListTag nbtOrderList = new ListTag();
        for (DepositOrder depositOrder : this.depositOrderQueue) {
            nbtOrderList.add((Object)depositOrder.writeToNBT(new CompoundTag()));
        }
        compound.m_128365_("depositOrders", (Tag)nbtOrderList);
        return super.writeJobToNBT(compound);
    }

    @Override
    public void readJobFromNBT(CompoundTag compound) {
        if (compound.m_128441_("storageControllerPosition")) {
            this.storageControllerPosition = GlobalBlockPos.from(compound.m_128469_("storageControllerPosition"));
        }
        if (compound.m_128441_("managedMachine")) {
            this.managedMachine = MachineReference.from(compound.m_128469_("managedMachine"));
        }
        if (compound.m_128441_("currentDepositOrder")) {
            this.setCurrentDepositOrder(DepositOrder.from(compound.m_128469_("currentDepositOrder")));
        }
        this.depositOrderQueue = new ArrayDeque<DepositOrder>();
        if (compound.m_128441_("depositOrders")) {
            ListTag nbtOrderList = compound.m_128437_("depositOrders", 10);
            for (int i = 0; i < nbtOrderList.size(); ++i) {
                DepositOrder depositOrder = DepositOrder.from(nbtOrderList.m_128728_(i));
                this.depositOrderQueue.add(depositOrder);
            }
        }
        super.readJobFromNBT(compound);
    }

    public void addDepsitOrder(DepositOrder order) {
        this.depositOrderQueue.add(order);
    }

    public void clearAllOrders() {
        this.currentDepositOrder = null;
        this.depositOrderQueue.clear();
    }

    protected void registerWithStorageController() {
        IStorageController storageController = this.getStorageController();
        if (storageController != null && this.managedMachine != null) {
            storageController.addDepositOrderSpirit(this.managedMachine.insertGlobalPos, this.entity.m_142081_());
            storageController.linkMachine(this.managedMachine);
            BlockEntityUtil.updateTile(this.entity.f_19853_, this.getStorageControllerPosition().getPos());
        }
    }

    protected void unregisterFromStorageController() {
        IStorageController storageController;
        if (this.storageControllerPosition != null && this.managedMachine != null && (storageController = this.getStorageController()) != null) {
            storageController.removeDepositOrderSpirit(this.managedMachine.insertGlobalPos);
        }
    }
}

