/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.job;

import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.SpiritJob;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.phys.Vec3;

public abstract class ChangeWeatherJob
extends SpiritJob {
    protected int currentChangeTicks;
    protected int requiredChangeTicks;

    public ChangeWeatherJob(SpiritEntity entity, int requiredChangeTicks) {
        super(entity);
        this.requiredChangeTicks = requiredChangeTicks;
    }

    @Override
    public void init() {
    }

    @Override
    public void cleanup() {
        for (int i = 0; i < 5; ++i) {
            ((ServerLevel)this.entity.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.entity.m_20185_() + this.entity.f_19853_.m_5822_().nextGaussian(), this.entity.m_20186_() + 0.5 + this.entity.f_19853_.m_5822_().nextGaussian(), this.entity.m_20189_() + this.entity.f_19853_.m_5822_().nextGaussian(), 5, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void update() {
        super.update();
        ++this.currentChangeTicks;
        if (!this.entity.f_20911_) {
            this.entity.m_6674_(InteractionHand.MAIN_HAND);
        }
        if (this.entity.f_19853_.m_46467_() % 2L == 0L) {
            ((ServerLevel)this.entity.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.entity.m_20185_(), this.entity.m_20186_() + 0.5, this.entity.m_20189_(), 3, 0.5, 0.0, 0.0, 0.0);
        }
        if (this.currentChangeTicks == this.requiredChangeTicks) {
            this.changeWeather();
            LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(this.entity.f_19853_);
            lightningboltentity.m_20219_(Vec3.m_82539_((Vec3i)this.entity.m_142538_()));
            lightningboltentity.m_20874_(true);
            this.entity.m_6667_(DamageSource.f_19306_);
            this.entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public CompoundTag writeJobToNBT(CompoundTag compound) {
        compound.m_128405_("currentChangeTicks", this.currentChangeTicks);
        compound.m_128405_("requiredChangeTicks", this.requiredChangeTicks);
        return super.writeJobToNBT(compound);
    }

    @Override
    public void readJobFromNBT(CompoundTag compound) {
        super.readJobFromNBT(compound);
        this.currentChangeTicks = compound.m_128451_("currentChangeTicks");
        this.requiredChangeTicks = compound.m_128451_("requiredChangeTicks");
    }

    public abstract void changeWeather();
}

